/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.peoplematter.transformers;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import org.mule.api.transformer.TransformerException;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;
import org.mule.util.IOUtils;

public class PeopleMatterEventToXmlTransformer
extends AbstractTransformer {
    private static final String HRXML_REQUEST_PARAMETER = "hrxml=";

    public PeopleMatterEventToXmlTransformer() {
        this.registerSourceType(DataTypeFactory.STRING);
        this.registerSourceType(DataTypeFactory.BYTE_ARRAY);
        this.registerSourceType(DataTypeFactory.INPUT_STREAM);
        this.setReturnDataType(DataTypeFactory.STRING);
    }

    public Object doTransform(Object src, String encoding) throws TransformerException {
        return this.extractPayload(this.convertRequestToString(src, encoding));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String convertRequestToString(Object src, String encoding) {
        String srcAsString = null;
        if (src instanceof byte[]) {
            if (encoding != null) {
                try {
                    srcAsString = new String((byte[])src, encoding);
                }
                catch (UnsupportedEncodingException ex) {
                    srcAsString = new String((byte[])src);
                }
            } else {
                srcAsString = new String((byte[])src);
            }
        } else if (src instanceof InputStream) {
            InputStream input = (InputStream)src;
            try {
                srcAsString = IOUtils.toString((InputStream)input);
            }
            finally {
                IOUtils.closeQuietly((InputStream)input);
            }
        } else {
            srcAsString = src.toString();
        }
        return srcAsString;
    }

    private String extractPayload(String messageBody) throws TransformerException {
        String hrXmlValue = null;
        if (messageBody != null && messageBody.length() > 0) {
            int hrXmlParameterPos = messageBody.indexOf(HRXML_REQUEST_PARAMETER);
            if (hrXmlParameterPos != -1) {
                int nextParameterValuePos = messageBody.indexOf(38);
                if (nextParameterValuePos == -1 || nextParameterValuePos < hrXmlParameterPos) {
                    nextParameterValuePos = messageBody.length();
                }
                hrXmlValue = messageBody.substring(hrXmlParameterPos + HRXML_REQUEST_PARAMETER.length(), nextParameterValuePos);
            }
            if (hrXmlValue != null && hrXmlValue.length() > 0) {
                try {
                    hrXmlValue = URLDecoder.decode(hrXmlValue, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    this.logger.error((Object)uee.getMessage());
                }
            }
        }
        if (hrXmlValue == null) {
            hrXmlValue = "";
        }
        return hrXmlValue;
    }
}

