/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.peoplematter.filters;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.crypto.spec.SecretKeySpec;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.mule.api.MessagingException;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.construct.FlowConstruct;
import org.mule.api.construct.FlowConstructAware;
import org.mule.api.lifecycle.Initialisable;
import org.mule.api.lifecycle.InitialisationException;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.routing.RoutingException;
import org.mule.api.store.ObjectStore;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.CoreMessages;
import org.mule.processor.AbstractFilteringMessageProcessor;
import org.mule.util.store.TextFileObjectStore;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PeopleMatterSecureEventMessageFilter
extends AbstractFilteringMessageProcessor
implements FlowConstructAware,
Initialisable {
    protected volatile ObjectStore<String> store;
    protected volatile String assignedComponentName;
    protected FlowConstruct flowConstruct;
    protected String key = null;
    protected static final String HRXML_KEY_NAME = "hrxml=";
    protected static int TTL_24HOURS = 86400000;
    protected static int EXPIRATIONCHECK_1MINUTE = 60000;
    protected static final String NONCE_ELEMENT = "nonce";
    protected static final String SIGNATURE_ELEMENT = "Signature";
    protected static final String AUTHENTICATION_OBJECT_ID = "AuthenticationObject";
    protected static final String ID_ELEMENT = "Id";
    protected static final String OBJECT_ELEMENT = "Object";
    protected static final String AUTHENTICATION_ELEMENT = "authentication";
    protected static final String TIMESTAMP_ELEMENT = "timestamp";

    public void initialise() throws InitialisationException {
        if (this.store == null) {
            this.store = this.createMessageIdStore();
        }
    }

    public void setFlowConstruct(FlowConstruct flowConstruct) {
        this.flowConstruct = flowConstruct;
    }

    public String getKey() {
        return this.key;
    }

    public void setKey(String key) {
        this.key = key;
    }

    public ObjectStore<String> getStore() {
        return this.store;
    }

    public void setStore(ObjectStore<String> store) {
        this.store = store;
    }

    protected ObjectStore<String> createMessageIdStore() throws InitialisationException {
        TextFileObjectStore s = new TextFileObjectStore();
        s.setMuleContext(this.getMuleContext());
        s.setName(this.assignedComponentName);
        s.setMaxEntries(-1);
        s.setEntryTTL(TTL_24HOURS);
        s.setExpirationInterval(EXPIRATIONCHECK_1MINUTE);
        s.initialise();
        return s;
    }

    protected MuleEvent processNext(MuleEvent event) throws MuleException {
        String id = this.getIdForEvent(event);
        try {
            this.store.store((Serializable)((Object)id), (Serializable)((Object)id));
            return super.processNext(event);
        }
        catch (Exception e) {
            throw new RoutingException(CoreMessages.failedToWriteMessageToStore((Object)id, (String)this.assignedComponentName), event, (MessageProcessor)this, (Throwable)e);
        }
    }

    protected String getIdForEvent(MuleEvent event) throws MessagingException {
        try {
            Element el = this.getAuthenticationNode(event);
            NodeList nl = el.getElementsByTagName(NONCE_ELEMENT);
            if (nl.getLength() == 0) {
                throw new Exception("Cannot find nonce element");
            }
            return nl.item(0).getTextContent();
        }
        catch (Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    protected boolean accept(MuleEvent event) {
        return event != null && this.acceptMessageForFlowConstruct(event) && this.isValidMessage(event);
    }

    protected boolean acceptMessageForFlowConstruct(MuleEvent event) {
        if (this.flowConstruct.getName().equals(event.getFlowConstruct().getName())) {
            return true;
        }
        this.logger.error((Object)("This Event was configured on the service: " + this.assignedComponentName + " but has received an event for service: " + this.flowConstruct.getName() + ". Please check your config to make sure each service" + "has its own instance of Event."));
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean isValidMessage(MuleEvent event) {
        try {
            Element el = this.getAuthenticationNode(event);
            NodeList nl = el.getElementsByTagName(TIMESTAMP_ELEMENT);
            if (nl.getLength() == 0) {
                throw new Exception("Cannot find timestamp element");
            }
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
            Date timestamp = sdf.parse(nl.item(0).getTextContent());
            Date now = new Date();
            if (now.getTime() - (long)TTL_24HOURS > timestamp.getTime()) {
                throw new Exception("Message older than 24 hours");
            }
            nl = el.getElementsByTagName(NONCE_ELEMENT);
            if (nl.getLength() == 0) {
                throw new Exception("Cannot find nonce element");
            }
            if (this.store == null) {
                PeopleMatterSecureEventMessageFilter peopleMatterSecureEventMessageFilter = this;
                synchronized (peopleMatterSecureEventMessageFilter) {
                    this.initialise();
                }
            }
            return !this.store.contains((Serializable)((Object)nl.item(0).getTextContent()));
        }
        catch (Exception e) {
            this.logger.error((Object)("Exception attempting to determine idempotency of incoming message for " + event.getFlowConstruct().getName() + " from the endpoint " + event.getMessageSourceURI()), (Throwable)e);
            return false;
        }
    }

    private Element getAuthenticationNode(MuleEvent event) throws MessagingException {
        try {
            Document document = this.convertXMLStringToDocument(this.extractPayload(event.getMessageAsString()));
            if (this.isXmlDigitalSignatureValid(document)) {
                Element el = this.getAuthenticationElement(document);
                NodeList nl = el.getElementsByTagName(AUTHENTICATION_ELEMENT);
                if (nl.getLength() == 0) {
                    throw new Exception("Cannot find authentication element");
                }
                return (Element)nl.item(0);
            }
            throw new Exception("XML digital signature is not valid");
        }
        catch (Exception e) {
            throw new MessagingException(event, (Throwable)e);
        }
    }

    private Element getAuthenticationElement(Document document) throws Exception {
        NodeList nl = document.getElementsByTagName(OBJECT_ELEMENT);
        if (nl.getLength() == 0) {
            throw new Exception("Cannot find authentication element");
        }
        for (int i = 0; i < nl.getLength(); ++i) {
            Node idAttribute;
            Node node = nl.item(i);
            NamedNodeMap attributes = node.getAttributes();
            if (attributes == null || attributes.getLength() <= 0 || (idAttribute = attributes.getNamedItem(ID_ELEMENT)) == null || idAttribute.getNodeValue().compareTo(AUTHENTICATION_OBJECT_ID) != 0) continue;
            return (Element)node;
        }
        return null;
    }

    private String extractPayload(String messageBody) throws TransformerException {
        String hrXmlValue = null;
        if (messageBody != null && messageBody.length() > 0) {
            int hrXmlKeyPosition = messageBody.indexOf(HRXML_KEY_NAME);
            if (hrXmlKeyPosition != -1) {
                int nextKeyPosition = messageBody.indexOf(38);
                if (nextKeyPosition == -1 || nextKeyPosition < hrXmlKeyPosition) {
                    nextKeyPosition = messageBody.length();
                }
                hrXmlValue = messageBody.substring(hrXmlKeyPosition + HRXML_KEY_NAME.length(), nextKeyPosition);
            }
            if (hrXmlValue != null && hrXmlValue.length() > 0) {
                try {
                    hrXmlValue = URLDecoder.decode(hrXmlValue, "UTF-8");
                }
                catch (UnsupportedEncodingException uee) {
                    this.logger.error((Object)uee.getMessage());
                }
            }
        }
        if (hrXmlValue == null) {
            hrXmlValue = "";
        }
        return hrXmlValue;
    }

    private Document convertXMLStringToDocument(String payload) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException ex) {
            // empty catch block
        }
        Document document = builder.parse(new ByteArrayInputStream(payload.getBytes()));
        return document;
    }

    private boolean isXmlDigitalSignatureValid(Document document) throws Exception {
        NodeList nl = document.getElementsByTagNameNS("http://www.w3.org/2000/09/xmldsig#", SIGNATURE_ELEMENT);
        if (nl.getLength() == 0) {
            throw new Exception("Cannot find Signature element");
        }
        DOMValidateContext valContext = new DOMValidateContext(new SecretKeySpec(this.key.getBytes(), "HmacSHA256"), nl.item(0));
        XMLSignatureFactory factory = XMLSignatureFactory.getInstance("DOM");
        XMLSignature signature = factory.unmarshalXMLSignature(valContext);
        return signature.validate(valContext);
    }
}

