/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira.process;

import org.mule.api.Connection;
import org.mule.api.ConnectionManager;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.UnableToAcquireConnectionException;
import org.mule.api.UnableToReleaseConnectionException;
import org.mule.api.process.ProcessCallback;
import org.mule.api.process.ProcessInterceptor;
import org.mule.api.processor.MessageProcessor;
import org.mule.module.jira.adapters.JiraConnectorConnectionIdentifierAdapter;
import org.mule.module.jira.connectivity.JiraConnectorConnectionKey;
import org.mule.module.jira.processors.AbstractConnectedProcessor;
import org.mule.module.jira.processors.AbstractExpressionEvaluator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ManagedConnectionProcessInterceptor<T>
extends AbstractExpressionEvaluator
implements ProcessInterceptor<T, JiraConnectorConnectionIdentifierAdapter> {
    private static Logger logger = LoggerFactory.getLogger(ManagedConnectionProcessInterceptor.class);
    private final ConnectionManager<JiraConnectorConnectionKey, JiraConnectorConnectionIdentifierAdapter> connectionManager;
    private final MuleContext muleContext;
    private final ProcessInterceptor<T, JiraConnectorConnectionIdentifierAdapter> next;

    public ManagedConnectionProcessInterceptor(ProcessInterceptor<T, JiraConnectorConnectionIdentifierAdapter> next, ConnectionManager<JiraConnectorConnectionKey, JiraConnectorConnectionIdentifierAdapter> connectionManager, MuleContext muleContext) {
        this.next = next;
        this.connectionManager = connectionManager;
        this.muleContext = muleContext;
    }

    public T execute(ProcessCallback<T, JiraConnectorConnectionIdentifierAdapter> processCallback, JiraConnectorConnectionIdentifierAdapter object, MessageProcessor messageProcessor, MuleEvent event) throws Exception {
        Object _transformedConnectionUser;
        JiraConnectorConnectionIdentifierAdapter connection = null;
        JiraConnectorConnectionKey key = null;
        if (messageProcessor != null && messageProcessor instanceof AbstractConnectedProcessor && ((AbstractConnectedProcessor)messageProcessor).getConnectionUser() != null) {
            _transformedConnectionUser = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_connectionUserType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getConnectionUser());
            String _transformedConnectionPassword = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_connectionPasswordType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getConnectionPassword());
            String _transformedConnectionAddress = (String)this.evaluateAndTransform(this.muleContext, event, AbstractConnectedProcessor.class.getDeclaredField("_connectionAddressType").getGenericType(), null, ((AbstractConnectedProcessor)messageProcessor).getConnectionAddress());
            key = new JiraConnectorConnectionKey((String)_transformedConnectionUser, _transformedConnectionPassword, _transformedConnectionAddress);
        } else {
            key = (JiraConnectorConnectionKey)this.connectionManager.getDefaultConnectionKey();
        }
        try {
            if (logger.isDebugEnabled()) {
                logger.debug("Attempting to acquire connection using " + key.toString());
            }
            if ((connection = (JiraConnectorConnectionIdentifierAdapter)this.connectionManager.acquireConnection((Object)key)) == null) {
                throw new UnableToAcquireConnectionException();
            }
            if (logger.isDebugEnabled()) {
                logger.debug("Connection has been acquired with [id=" + connection.getConnectionIdentifier() + "]");
            }
            _transformedConnectionUser = this.next.execute(processCallback, (Object)connection, messageProcessor, event);
            return (T)_transformedConnectionUser;
        }
        catch (Exception e) {
            if (processCallback.getManagedExceptions() != null) {
                for (Class exceptionClass : processCallback.getManagedExceptions()) {
                    if (!exceptionClass.isInstance(e)) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("An exception ( " + exceptionClass.getName() + ") has been thrown. Destroying the connection with [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    try {
                        this.connectionManager.destroyConnection((Object)key, (Connection)connection);
                        connection = null;
                    }
                    catch (Exception innerException) {
                        logger.error(innerException.getMessage(), (Throwable)innerException);
                    }
                }
            }
            throw e;
        }
        finally {
            try {
                if (connection != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("Releasing the connection back into the pool [id=" + connection.getConnectionIdentifier() + "]");
                    }
                    this.connectionManager.releaseConnection((Object)key, (Connection)connection);
                }
            }
            catch (Exception e) {
                throw new UnableToReleaseConnectionException((Throwable)e);
            }
        }
    }
}

