/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira.transformers;

import java.util.Calendar;
import javax.xml.bind.DatatypeConverter;
import org.mule.api.transformer.DiscoverableTransformer;
import org.mule.api.transformer.Transformer;
import org.mule.api.transformer.TransformerException;
import org.mule.config.i18n.MessageFactory;
import org.mule.transformer.AbstractTransformer;
import org.mule.transformer.types.DataTypeFactory;

public class StringToCalendarTransformer
extends AbstractTransformer
implements DiscoverableTransformer {
    private int priorityWeighting = 1;

    public StringToCalendarTransformer() {
        this.registerSourceType(DataTypeFactory.create(String.class));
        this.setReturnClass(Calendar.class);
        this.setName("StringToCalendarTransformer");
    }

    protected Object doTransform(Object src, String encoding) throws TransformerException {
        try {
            return DatatypeConverter.parseDateTime((String)src.toString());
        }
        catch (IllegalArgumentException e) {
            throw new TransformerException(MessageFactory.createStaticMessage((String)String.format("Could not parse %s as a valid xsd:dateTime", src)), (Transformer)this, (Throwable)e);
        }
    }

    public int getPriorityWeighting() {
        return this.priorityWeighting;
    }

    public void setPriorityWeighting(int value) {
        this.priorityWeighting = value;
    }
}

