/*
 * Decompiled with CFR 0.152.
 */
package org.mule.module.jira;

import com.atlassian.jira.rpc.soap.beans.RemoteAvatar;
import com.atlassian.jira.rpc.soap.beans.RemoteComment;
import com.atlassian.jira.rpc.soap.beans.RemoteConfiguration;
import com.atlassian.jira.rpc.soap.beans.RemoteField;
import com.atlassian.jira.rpc.soap.beans.RemoteGroup;
import com.atlassian.jira.rpc.soap.beans.RemoteIssue;
import com.atlassian.jira.rpc.soap.beans.RemotePermissionScheme;
import com.atlassian.jira.rpc.soap.beans.RemoteProject;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRole;
import com.atlassian.jira.rpc.soap.beans.RemoteProjectRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteRoleActors;
import com.atlassian.jira.rpc.soap.beans.RemoteSecurityLevel;
import com.atlassian.jira.rpc.soap.beans.RemoteServerInfo;
import com.atlassian.jira.rpc.soap.beans.RemoteUser;
import com.atlassian.jira.rpc.soap.beans.RemoteVersion;
import com.atlassian.jira.rpc.soap.beans.RemoteWorklog;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.mule.api.ConnectionException;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Connect;
import org.mule.api.annotations.ConnectionIdentifier;
import org.mule.api.annotations.Connector;
import org.mule.api.annotations.Disconnect;
import org.mule.api.annotations.InvalidateConnectionOn;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.ValidateConnection;
import org.mule.api.annotations.display.Placement;
import org.mule.api.annotations.param.ConnectionKey;
import org.mule.api.annotations.param.Default;
import org.mule.api.annotations.param.Optional;
import org.mule.module.jira.JiraClientAdaptor;
import org.mule.module.jira.JiraClientFactory;
import org.mule.module.jira.JiraConnectorException;
import org.mule.module.jira.api.JiraClient;

@Connector(name="jira", schemaVersion="2.0", friendlyName="Jira")
public class JiraConnector {
    private JiraClient<List<Object>> client;
    private String token;
    private String connectionUser;
    private String connectionAddress;
    @Configurable
    @Optional
    @Default(value="false")
    private Boolean useCustomFieldsExternalName;
    private static final String MULTIVALUED_FIELD_SEPARATOR = "\\|";
    private Map<String, String> customFieldsNamesToIdsMapping = null;
    private Calendar customFieldsCacheExpiration = null;

    private Map<String, String> getCustomFieldsNamesToIdsMapping() {
        if (this.customFieldsNamesToIdsMapping == null || new GregorianCalendar().after(this.customFieldsCacheExpiration)) {
            this.customFieldsNamesToIdsMapping = new HashMap<String, String>();
            List<Object> customFields = this.client.getCustomFields(this.token);
            for (Object customField : customFields) {
                RemoteField remoteField = (RemoteField)customField;
                this.customFieldsNamesToIdsMapping.put(remoteField.getName(), remoteField.getId());
            }
            this.customFieldsCacheExpiration = new GregorianCalendar();
            this.customFieldsCacheExpiration.add(11, 1);
        }
        return this.customFieldsNamesToIdsMapping;
    }

    private Map<String, List<String>> convertFieldsToMultivaluedAndMapNamesToIds(Map<String, String> fields) {
        HashMap<String, List<String>> multivaluedFields = new HashMap<String, List<String>>();
        if (fields != null) {
            for (Map.Entry<String, String> field : fields.entrySet()) {
                String value;
                Map<String, String> customFields;
                String id;
                String fieldKey = field.getKey();
                if (this.useCustomFieldsExternalName.booleanValue() && (id = (customFields = this.getCustomFieldsNamesToIdsMapping()).get(fieldKey)) != null) {
                    fieldKey = id;
                }
                if ((value = field.getValue()) == null) {
                    value = "";
                }
                multivaluedFields.put(fieldKey, Arrays.asList(value.split(MULTIVALUED_FIELD_SEPARATOR)));
            }
        }
        return multivaluedFields;
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteComment getComment(Long commentId) {
        return this.client.getComment(this.token, commentId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteConfiguration getConfiguration() {
        return this.client.getConfiguration(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteGroup createGroup(String groupName, @Optional String userName) {
        return this.client.createGroup(this.token, groupName, userName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteServerInfo getServerInfo() {
        return this.client.getServerInfo(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteGroup getGroup(String groupName) {
        return this.client.getGroup(this.token, groupName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteUser createUser(String username, String password, String fullName, String email) {
        return this.client.createUser(this.token, username, password, fullName, email);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void addComment(String issueKey, String commentAuthor, String commentBody, @Optional String commentGroupLevel, @Optional String commentRoleLevel) {
        this.client.addComment(this.token, issueKey, commentAuthor, commentBody, commentGroupLevel, commentRoleLevel);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getComponents(String projectKey) {
        return this.client.getComponents(this.token, projectKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteUser getUser(String username) {
        return this.client.getUser(this.token, username);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteGroup updateGroup(String groupName, List<String> usernames) {
        return this.client.updateGroup(this.token, groupName, usernames);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void addUserToGroup(String groupName, String userName) {
        this.client.addUserToGroup(this.token, groupName, userName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void removeUserFromGroup(String groupName, String userName) {
        this.client.removeUserFromGroup(this.token, groupName, userName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteIssue getIssue(String issueKey) {
        return this.client.getIssue(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteIssue createIssue(@Optional String assignee, @Placement(group="Basic", order=3) String summary, @Optional @Placement(group="Basic", order=4) String description, @Optional String dueDate, @Optional String environment, @Optional String priority, @Placement(group="Basic", order=1) String project, @Optional String reporter, @Placement(group="Basic", order=2) String type, @Optional Long votes, @Optional @Placement(group="Custom Fields") Map<String, String> customFields, @Optional String componentName, @Optional String componentId) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(customFields);
        return this.client.createIssue(this.token, assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, multivaluedFields, componentName, componentId);
    }

    @Processor(name="create-issue-using-object")
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteIssue createIssueUsingObject(@Optional @Default(value="#[payload]") RemoteIssue issue) {
        return this.client.createIssue(this.token, issue);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteIssue createIssueWithSecurityLevel(@Optional String assignee, String summary, @Optional String description, @Optional String dueDate, @Optional String environment, @Optional String priority, String project, @Optional String reporter, String type, @Optional Long votes, @Optional Map<String, String> customFields, Long securityLevelId, @Optional String componentName, @Optional String componentId) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(customFields);
        return this.client.createIssueWithSecurityLevel(this.token, assignee, summary, description, dueDate, environment, priority, project, reporter, type, votes, multivaluedFields, securityLevelId, componentName, componentId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteIssue updateIssue(String issueKey, Map<String, String> fields) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
        return this.client.updateIssue(this.token, issueKey, multivaluedFields);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<RemoteIssue> updateIssuesByJql(String jql, Map<String, String> fields, @Optional Integer maxRecordsToUpdate) {
        List<Object> issuesToUpdate = this.client.getIssuesFromJqlSearch(this.token, jql, 10000);
        if (issuesToUpdate != null && maxRecordsToUpdate != null && issuesToUpdate.size() > maxRecordsToUpdate) {
            throw new JiraConnectorException("Couldn't execute update-issues-by-jql. The number of issues found by the jql query (" + issuesToUpdate.size() + ") was greater than the maxRecordsToUpdate given (" + maxRecordsToUpdate + ")");
        }
        if (CollectionUtils.isNotEmpty(issuesToUpdate)) {
            ArrayList<RemoteIssue> result = new ArrayList<RemoteIssue>();
            Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
            for (Object issue : issuesToUpdate) {
                RemoteIssue updatedIssue = this.client.updateIssue(this.token, ((RemoteIssue)issue).getKey(), multivaluedFields);
                result.add(updatedIssue);
            }
            return result;
        }
        throw new JiraConnectorException("Can't execute update. The jql search returned no issues");
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteIssue(String issueKey) {
        this.client.deleteIssue(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getAvailableActions(String issueKey) {
        return this.client.getAvailableActions(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getSubTaskIssueTypes() {
        return this.client.getSubTaskIssueTypes(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteProject createProject(String key, String projectName, String description, @Optional String url, String lead, @Optional String permissionSchemeName, @Optional String notificationSchemeName, @Optional String securityShemeName) {
        return this.client.createProject(this.token, key, projectName, description, url, lead, permissionSchemeName, notificationSchemeName, securityShemeName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteProject updateProject(String key, String description, @Optional String url, String lead, @Optional String permissionSchemeName, @Optional String notificationSchemeName, @Optional String securityShemeName) {
        return this.client.updateProject(this.token, key, description, url, lead, permissionSchemeName, notificationSchemeName, securityShemeName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteProject getProjectByKey(String projectKey) {
        return this.client.getProjectByKey(this.token, projectKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void removeAllRoleActorsByProject(String projectKey) {
        this.client.removeAllRoleActorsByProject(this.token, projectKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getPriorities() {
        return this.client.getPriorities(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getResolutions() {
        return this.client.getResolutions(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getIssueTypes() {
        return this.client.getIssueTypes(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getStatuses() {
        return this.client.getStatuses(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getIssueTypesForProject(String projectId) {
        return this.client.getIssueTypesForProject(this.token, projectId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getProjectRoles() {
        return this.client.getProjectRoles(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteProjectRole getProjectRole(Long projectRoleId) {
        return this.client.getProjectRole(this.token, projectRoleId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteProjectRoleActors getProjectRoleActors(Long projectRoleId, String projectKey) {
        return this.client.getProjectRoleActors(this.token, projectRoleId, projectKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteRoleActors getDefaultRoleActors(Long projectRoleId) {
        return this.client.getDefaultRoleActors(this.token, projectRoleId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void removeAllRoleActorsByNameAndType(String roleName, String type) {
        this.client.removeAllRoleActorsByNameAndType(this.token, roleName, type);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteProjectRole(Long projectRoleId, Boolean confirm) {
        this.client.deleteProjectRole(this.token, projectRoleId, confirm);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void updateProjectRole(Long projectRoleId, @Optional String projectRoleName, @Optional String projectRoleDescription) {
        this.client.updateProjectRole(this.token, projectRoleId, projectRoleName, projectRoleDescription);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteProjectRole createProjectRole(String projectRoleName, String projectRoleDescription) {
        return this.client.createProjectRole(this.token, projectRoleName, projectRoleDescription);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public boolean isProjectRoleNameUnique(String roleName) {
        return this.client.isProjectRoleNameUnique(this.token, roleName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void releaseVersion(String projectKey, String versionName) {
        this.client.releaseVersion(this.token, projectKey, versionName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void addActorsToProjectRole(List<String> actors, Long projectRoleId, String projectKey, @Optional String actorType) {
        this.client.addActorsToProjectRole(this.token, actors, projectRoleId, projectKey, actorType);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void removeActorsFromProjectRole(List<String> actors, Long projectRoleId, String projectKey, @Optional String actorType) {
        this.client.removeActorsFromProjectRole(this.token, actors, projectRoleId, projectKey, actorType);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void addDefaultActorsToProjectRole(List<String> actors, Long projectRoleId, @Optional String type) {
        this.client.addDefaultActorsToProjectRole(this.token, actors, projectRoleId, type);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void removeDefaultActorsFromProjectRole(List<String> actors, Long remoteProjectRoleId, @Optional String type) {
        this.client.removeDefaultActorsFromProjectRole(this.token, actors, remoteProjectRoleId, type);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getAssociatedNotificationSchemes(Long projectRoleId) {
        return this.client.getAssociatedNotificationSchemes(this.token, projectRoleId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getAssociatedPermissionSchemes(Long projectRoleId) {
        return this.client.getAssociatedPermissionSchemes(this.token, projectRoleId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteProject(String projectKey) {
        this.client.deleteProject(this.token, projectKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteProject getProjectById(Long projectId) {
        return this.client.getProjectById(this.token, projectId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getVersions(String projectKey) {
        return this.client.getVersions(this.token, projectKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getComments(String issueKey) {
        return this.client.getComments(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getFavouriteFilters() {
        return this.client.getFavouriteFilters(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void archiveVersion(String projectKey, String versionName, Boolean archive) {
        this.client.archiveVersion(this.token, projectKey, versionName, archive);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getFieldsForEdit(String issueKey) {
        return this.client.getFieldsForEdit(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getSubTaskIssueTypesForProject(String projectId) {
        return this.client.getSubTaskIssueTypesForProject(this.token, projectId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public String login(String username, String password) {
        return this.client.login(username, password);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteSecurityLevel getSecurityLevel(String issueKey) {
        return this.client.getSecurityLevel(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getCustomFields() {
        return this.client.getCustomFields(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public boolean logout(String token) {
        return this.client.logout(token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteProject getProjectWithSchemesById(Long projectId) {
        return this.client.getProjectWithSchemesById(this.token, projectId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getSecurityLevels(String projectKey) {
        return this.client.getSecurityLevels(this.token, projectKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getProjectAvatars(String projectKey, Boolean includeSystemAvatars) {
        return this.client.getProjectAvatars(this.token, projectKey, includeSystemAvatars);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void setProjectAvatar(String projectKey, Long avatarId) {
        this.client.setProjectAvatar(this.token, projectKey, avatarId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteAvatar getProjectAvatar(String projectKey) {
        return this.client.getProjectAvatar(this.token, projectKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteProjectAvatar(Long avatarId) {
        this.client.deleteProjectAvatar(this.token, avatarId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getNotificationSchemes() {
        return this.client.getNotificationSchemes(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getPermissionSchemes() {
        return this.client.getPermissionSchemes(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getAllPermissions() {
        return this.client.getAllPermissions(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemotePermissionScheme createPermissionScheme(String permissionName, String description) {
        return this.client.createPermissionScheme(this.token, permissionName, description);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemotePermissionScheme addPermissionTo(String permissionSchemeName, Long permissionCode, String entityName) {
        return this.client.addPermissionTo(this.token, permissionSchemeName, permissionCode, entityName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemotePermissionScheme deletePermissionFrom(String permissionSchemeName, Long permissionCode, String entityName) {
        return this.client.deletePermissionFrom(this.token, permissionSchemeName, permissionCode, entityName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deletePermissionScheme(String permissionSchemeName) {
        this.client.deletePermissionScheme(this.token, permissionSchemeName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getAttachmentsFromIssue(String issueKey) {
        return this.client.getAttachmentsFromIssue(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public boolean hasPermissionToEditComment(Long commentId) {
        return this.client.hasPermissionToEditComment(this.token, commentId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteComment editComment(Long commentId, @Optional String body, @Optional String updateAuthor) {
        return this.client.editComment(this.token, commentId, body, updateAuthor);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getFieldsForAction(String issueKey, String actionIdString) {
        return this.client.getFieldsForAction(this.token, issueKey, actionIdString);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteIssue getIssueById(String issueId) {
        return this.client.getIssueById(this.token, issueId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteWorklogWithNewRemainingEstimate(String workLogId, String newRemainingEstimate) {
        this.client.deleteWorklogWithNewRemainingEstimate(this.token, workLogId, newRemainingEstimate);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteWorklogAndAutoAdjustRemainingEstimate(String worklogId) {
        this.client.deleteWorklogAndAutoAdjustRemainingEstimate(this.token, worklogId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteWorklogAndRetainRemainingEstimate(String worklogId) {
        this.client.deleteWorklogAndRetainRemainingEstimate(this.token, worklogId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getWorklogs(String issueKey) {
        return this.client.getWorklogs(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public boolean hasPermissionToCreateWorklog(String issueKey) {
        return this.client.hasPermissionToCreateWorklog(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public boolean hasPermissionToDeleteWorklog(String worklogId) {
        return this.client.hasPermissionToDeleteWorklog(this.token, worklogId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public boolean hasPermissionToUpdateWorklog(String worklogId) {
        return this.client.hasPermissionToUpdateWorklog(this.token, worklogId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void updateWorklogWithNewRemainingEstimate(String issueKey, String worklogId, String newRemainingEstimate, @Optional String comment, @Optional String groupLevel, @Optional String roleLevelId) {
        this.client.updateWorklogWithNewRemainingEstimate(this.token, issueKey, worklogId, comment, groupLevel, roleLevelId, newRemainingEstimate);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteVersion addVersion(String projectKey, String versionName, Boolean archived, Boolean released, String releaseDate) {
        return this.client.addVersion(this.token, projectKey, versionName, archived, released, releaseDate);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public Calendar getResolutionDateByKey(String issueKey) {
        return this.client.getResolutionDateByKey(this.token, issueKey);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public Calendar getResolutionDateById(Long issueId) {
        return this.client.getResolutionDateById(this.token, issueId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public long getIssueCountForFilter(String filterId) {
        return this.client.getIssueCountForFilter(this.token, filterId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getIssuesFromTextSearchWithProject(List<String> projectKeys, String searchTerms, Integer maxNumResults) {
        return this.client.getIssuesFromTextSearchWithProject(this.token, projectKeys, searchTerms, maxNumResults);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getIssuesFromJqlSearch(String jqlSearch, Integer maxNumResults) {
        return this.client.getIssuesFromJqlSearch(this.token, jqlSearch, maxNumResults);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteUser(String username) {
        this.client.deleteUser(this.token, username);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void deleteGroup(String groupName, @Optional String swapGroupName) {
        this.client.deleteGroup(this.token, groupName, swapGroupName);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void refreshCustomFields() {
        this.client.refreshCustomFields(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public boolean addBase64EncodedAttachmentsToIssue(String issueKey, List<String> fileNames, List<String> base64EncodedAttachmentData) {
        return this.client.addBase64EncodedAttachmentsToIssue(this.token, issueKey, fileNames, base64EncodedAttachmentData);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getIssuesFromFilterWithLimit(String filterId, Integer offset, Integer maxNumResults) {
        return this.client.getIssuesFromFilterWithLimit(this.token, filterId, offset, maxNumResults);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getIssuesFromTextSearchWithLimit(String searchTerms, Integer offset, Integer maxNumResults) {
        return this.client.getIssuesFromTextSearchWithLimit(this.token, searchTerms, offset, maxNumResults);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getProjectsNoSchemes() {
        return this.client.getProjectsNoSchemes(this.token);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public void setNewProjectAvatar(String projectKey, String contentType, String base64ImageData) {
        this.client.setNewProjectAvatar(this.token, projectKey, contentType, base64ImageData);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteIssue progressWorkflowAction(String issueKey, String actionIdString, @Optional Map<String, String> fields) {
        Map<String, List<String>> multivaluedFields = this.convertFieldsToMultivaluedAndMapNamesToIds(fields);
        return this.client.progressWorkflowAction(this.token, issueKey, actionIdString, multivaluedFields);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteWorklog addWorklogAndAutoAdjustRemainingEstimate(String issueKey, String timeSpent, String startDate, @Optional String comment, @Optional String groupLevel, @Optional String roleLevelId) {
        return this.client.addWorklogAndAutoAdjustRemainingEstimate(this.token, issueKey, timeSpent, startDate, comment, groupLevel, roleLevelId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteWorklog addWorklogWithNewRemainingEstimate(String issueKey, String timeSpent, String startDate, String newRemainingEstimate, @Optional String comment, @Optional String groupLevel, @Optional String roleLevelId) {
        return this.client.addWorklogWithNewRemainingEstimate(this.token, issueKey, timeSpent, startDate, newRemainingEstimate, comment, groupLevel, roleLevelId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public RemoteWorklog addWorklogAndRetainRemainingEstimate(String issueKey, String timeSpent, String startDate, @Optional String comment, @Optional String groupLevel, @Optional String roleLevelId) {
        return this.client.addWorklogAndRetainRemainingEstimate(this.token, issueKey, timeSpent, startDate, comment, groupLevel, roleLevelId);
    }

    @Processor
    @InvalidateConnectionOn(exception=JiraConnectorException.class)
    public List<Object> getSecuritySchemes() {
        return this.client.getSecuritySchemes(this.token);
    }

    public void setClient(JiraClient<?> client) {
        this.client = JiraClientAdaptor.adapt(client);
    }

    public String getConnectionUser() {
        return this.connectionUser;
    }

    public void setConnectionUser(String connectionUser) {
        this.connectionUser = connectionUser;
    }

    public String getConnectionAddress() {
        return this.connectionAddress;
    }

    public void setConnectionAddress(String connectionAddress) {
        this.connectionAddress = connectionAddress;
    }

    public Boolean getUseCustomFieldsExternalName() {
        return this.useCustomFieldsExternalName;
    }

    public void setUseCustomFieldsExternalName(Boolean useCustomFieldsExternalName) {
        this.useCustomFieldsExternalName = useCustomFieldsExternalName;
    }

    @Connect
    public void connect(@ConnectionKey String connectionUser, String connectionPassword, String connectionAddress) throws ConnectionException {
        this.connectionUser = connectionUser;
        this.connectionAddress = connectionAddress;
        this.setClient(JiraClientFactory.getClient(connectionAddress));
        this.token = this.login(connectionUser, connectionPassword);
    }

    @Disconnect
    public void disconnect() {
        if (this.token != null) {
            String oldToken = this.token;
            this.token = null;
            this.logout(oldToken);
            this.client = null;
        }
    }

    @ValidateConnection
    public boolean validateConnection() {
        return this.token != null;
    }

    @ConnectionIdentifier
    public String toString() {
        return "username='" + this.connectionUser + '\'' + ", address='" + this.connectionAddress + '\'' + '}';
    }
}

