/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Optional;
import org.mule.api.context.MuleContextAware;
import org.mule.api.el.ExpressionLanguageContext;
import org.mule.api.el.ExpressionLanguageExtension;
import org.mule.api.el.ExpressionLanguageFunction;
import org.mule.api.processor.MessageProcessor;
import org.mule.munit.Attribute;
import org.mule.munit.MunitMuleMessage;
import org.mule.munit.NestedMessageProcessor;
import org.mule.munit.common.mocking.EndpointMocker;
import org.mule.munit.common.mocking.MessageProcessorMocker;
import org.mule.munit.common.mocking.MunitSpy;
import org.mule.munit.common.mocking.MunitVerifier;
import org.mule.munit.common.mocking.NotDefinedPayload;
import org.mule.munit.common.mocking.SpyProcess;
import org.mule.munit.functions.AnyClassMatcherFunction;
import org.mule.munit.functions.AnyMatcherFunction;
import org.mule.munit.functions.EqMatcherFunction;
import org.mule.munit.functions.FlowResultFunction;
import org.mule.munit.functions.GetResourceFunction;
import org.mule.munit.functions.NotNullMatcherFunction;
import org.mule.munit.functions.NullMatcherFunction;

@Module(name="mock", schemaVersion="3.3")
public class MockModule
implements MuleContextAware,
ExpressionLanguageExtension {
    private MuleContext muleContext;

    @Processor
    public void when(String messageProcessor, @Optional List<Attribute> withAttributes, @Optional MunitMuleMessage thenReturn) {
        MunitMuleMessage munitMuleMessage = thenReturn == null ? new MunitMuleMessage() : thenReturn;
        this.mocker().when(this.getName(messageProcessor)).ofNamespace(this.getNamespace(messageProcessor)).withAttributes(this.createAttributes(withAttributes)).thenReturn(this.createMuleMessageFrom(munitMuleMessage.getPayload(), munitMuleMessage.getInboundProperties(), munitMuleMessage.getOutboundProperties(), munitMuleMessage.getSessionProperties(), munitMuleMessage.getInvocationProperties()));
    }

    @Processor
    public void spy(String messageProcessor, @Optional List<NestedProcessor> assertionsBeforeCall, @Optional List<NestedProcessor> assertionsAfterCall) {
        this.spy().spyMessageProcessor(this.getName(messageProcessor)).ofNamespace(this.getNamespace(messageProcessor)).running(this.createSpyAssertion(this.createMessageProcessorsFrom(assertionsBeforeCall)), this.createSpyAssertion(this.createMessageProcessorsFrom(assertionsAfterCall)));
    }

    @Processor
    public void throwAn(Throwable exception, String whenCalling, @Optional List<Attribute> withAttributes) {
        this.mocker().when(this.getName(whenCalling)).ofNamespace(this.getNamespace(whenCalling)).withAttributes(this.createAttributes(withAttributes)).thenThrow(exception);
    }

    @Processor
    public void verifyCall(String messageProcessor, @Optional List<Attribute> attributes, @Optional Integer times, @Optional Integer atLeast, @Optional Integer atMost) {
        MunitVerifier mockVerifier = new MunitVerifier(this.muleContext).verifyCallOfMessageProcessor(this.getName(messageProcessor)).ofNamespace(this.getNamespace(messageProcessor)).withAttributes(this.createAttributes(attributes));
        if (times != null) {
            mockVerifier.times(times);
        } else if (atLeast != null) {
            mockVerifier.atLeast(atLeast);
        } else if (atMost != null) {
            mockVerifier.atMost(atMost);
        } else {
            mockVerifier.atLeastOnce();
        }
    }

    @Processor
    public void outboundEndpoint(String address, @Optional Object returnPayload, @Optional Map<String, Object> returnInvocationProperties, @Optional Map<String, Object> returnInboundProperties, @Optional Map<String, Object> returnSessionProperties, @Optional Map<String, Object> returnOutboundProperties, @Optional List<NestedProcessor> assertions) {
        this.endpointMocker().expectEndpointWithAddress(address).withIncomingMessageSatisfying(this.createSpyAssertion(this.createMessageProcessorsFrom(assertions))).toReturn(this.createMuleMessageFrom(returnPayload, returnInboundProperties, returnOutboundProperties, returnSessionProperties, returnInvocationProperties));
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    public void configureContext(ExpressionLanguageContext context) {
        context.declareFunction("eq", (ExpressionLanguageFunction)new EqMatcherFunction());
        context.declareFunction("anyBoolean", (ExpressionLanguageFunction)new AnyMatcherFunction(Boolean.class));
        context.declareFunction("anyByte", (ExpressionLanguageFunction)new AnyMatcherFunction(Byte.class));
        context.declareFunction("anyInt", (ExpressionLanguageFunction)new AnyMatcherFunction(Integer.class));
        context.declareFunction("anyDouble", (ExpressionLanguageFunction)new AnyMatcherFunction(Double.class));
        context.declareFunction("anyFloat", (ExpressionLanguageFunction)new AnyMatcherFunction(Float.class));
        context.declareFunction("anyShort", (ExpressionLanguageFunction)new AnyMatcherFunction(Short.class));
        context.declareFunction("anyObject", (ExpressionLanguageFunction)new AnyMatcherFunction(Object.class));
        context.declareFunction("anyString", (ExpressionLanguageFunction)new AnyMatcherFunction(String.class));
        context.declareFunction("anyList", (ExpressionLanguageFunction)new AnyMatcherFunction(List.class));
        context.declareFunction("anySet", (ExpressionLanguageFunction)new AnyMatcherFunction(Set.class));
        context.declareFunction("anyMap", (ExpressionLanguageFunction)new AnyMatcherFunction(Map.class));
        context.declareFunction("anyCollection", (ExpressionLanguageFunction)new AnyMatcherFunction(Collection.class));
        context.declareFunction("isNull", (ExpressionLanguageFunction)new NullMatcherFunction());
        context.declareFunction("isNotNull", (ExpressionLanguageFunction)new NotNullMatcherFunction());
        context.declareFunction("any", (ExpressionLanguageFunction)new AnyClassMatcherFunction());
        context.declareFunction("resultOfScript", (ExpressionLanguageFunction)new FlowResultFunction(this.muleContext));
        context.declareFunction("getResource", (ExpressionLanguageFunction)new GetResourceFunction());
    }

    private MuleMessage createMuleMessageFrom(Object payload, Map<String, Object> inboundProperties, Map<String, Object> outboundProperties, Map<String, Object> sessionProperties, Map<String, Object> invocationProperties) {
        Object definedPayload = payload;
        if (payload == null) {
            definedPayload = NotDefinedPayload.getInstance();
        }
        DefaultMuleMessage message = new DefaultMuleMessage(definedPayload, this.muleContext);
        if (inboundProperties != null) {
            for (String property : inboundProperties.keySet()) {
                message.setInboundProperty(property, inboundProperties.get(property));
            }
        }
        if (outboundProperties != null) {
            for (String property : outboundProperties.keySet()) {
                message.setOutboundProperty(property, outboundProperties.get(property));
            }
        }
        if (invocationProperties != null) {
            for (String property : invocationProperties.keySet()) {
                message.setInvocationProperty(property, invocationProperties.get(property));
            }
        }
        return message;
    }

    private List<MessageProcessor> createMessageProcessorsFrom(List<NestedProcessor> assertions) {
        if (assertions == null) {
            return null;
        }
        ArrayList<MessageProcessor> mps = new ArrayList<MessageProcessor>();
        for (NestedProcessor nestedProcessor : assertions) {
            mps.add(new NestedMessageProcessor(nestedProcessor));
        }
        return mps;
    }

    private Map<String, Object> createAttributes(List<Attribute> attributes) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (attributes == null) {
            return attrs;
        }
        for (Attribute attr : attributes) {
            attrs.put(attr.getName(), attr.getWhereValue());
        }
        return attrs;
    }

    private String getNamespace(String when) {
        String[] split = when.split(":");
        if (split.length > 1) {
            return split[0];
        }
        return "mule";
    }

    private String getName(String when) {
        String[] split = when.split(":");
        if (split.length > 1) {
            return split[1];
        }
        return split[0];
    }

    private List<SpyProcess> createSpyAssertion(List<MessageProcessor> messageProcessorsFrom) {
        ArrayList<SpyProcess> mps = new ArrayList<SpyProcess>();
        mps.add(this.createSpy(messageProcessorsFrom));
        return mps;
    }

    protected SpyProcess createSpy(final List<MessageProcessor> messageProcessorsFrom) {
        return new SpyProcess(){

            public void spy(MuleEvent event) throws MuleException {
                for (MessageProcessor mp : messageProcessorsFrom) {
                    mp.process(event);
                }
            }
        };
    }

    protected MessageProcessorMocker mocker() {
        return new MessageProcessorMocker(this.muleContext);
    }

    protected EndpointMocker endpointMocker() {
        return new EndpointMocker(this.muleContext);
    }

    protected MunitSpy spy() {
        return new MunitSpy(this.muleContext);
    }
}

