/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.mule.DefaultMuleMessage;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.MuleMessage;
import org.mule.api.NestedProcessor;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.munit.Attribute;
import org.mule.munit.MunitMuleMessage;
import org.mule.munit.NestedMessageProcessor;
import org.mule.munit.common.MunitCore;
import org.mule.munit.common.mocking.EndpointMocker;
import org.mule.munit.common.mocking.MessageProcessorMocker;
import org.mule.munit.common.mocking.MunitSpy;
import org.mule.munit.common.mocking.MunitVerifier;
import org.mule.munit.common.mocking.NotDefinedPayload;
import org.mule.munit.common.mocking.SpyProcess;

public class MockModule
implements MuleContextAware {
    private MuleContext muleContext;

    public void when(String messageProcessor, List<Attribute> withAttributes, MunitMuleMessage thenReturn) {
        MunitMuleMessage munitMuleMessage = thenReturn == null ? new MunitMuleMessage() : thenReturn;
        this.mocker().when(MessageProcessorId.getName((String)messageProcessor)).ofNamespace(MessageProcessorId.getNamespace((String)messageProcessor)).withAttributes(this.createAttributes(withAttributes)).thenReturn(this.createMuleMessageFrom(munitMuleMessage.getPayload(), munitMuleMessage.getInboundProperties(), munitMuleMessage.getOutboundProperties(), munitMuleMessage.getSessionProperties(), munitMuleMessage.getInvocationProperties()));
    }

    public void spy(String messageProcessor, List<NestedProcessor> assertionsBeforeCall, List<NestedProcessor> assertionsAfterCall) {
        try {
            this.spy().spyMessageProcessor(MessageProcessorId.getName((String)messageProcessor)).ofNamespace(MessageProcessorId.getNamespace((String)messageProcessor)).running(this.createSpyAssertion(this.createMessageProcessorsFrom(assertionsBeforeCall)), this.createSpyAssertion(this.createMessageProcessorsFrom(assertionsAfterCall)));
        }
        catch (AssertionError error) {
            AssertionError exception = new AssertionError((Object)this.getMessage(error, "Spy Message Processor Failed"));
            ((Throwable)((Object)exception)).setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)this.muleContext).toArray(new StackTraceElement[0]));
            throw exception;
        }
    }

    public void throwAn(Throwable exception, String whenCalling, List<Attribute> withAttributes) {
        this.mocker().when(MessageProcessorId.getName((String)whenCalling)).ofNamespace(MessageProcessorId.getNamespace((String)whenCalling)).withAttributes(this.createAttributes(withAttributes)).thenThrow(exception);
    }

    public void verifyCall(String messageProcessor, List<Attribute> attributes, Integer times, Integer atLeast, Integer atMost) {
        try {
            MunitVerifier mockVerifier = new MunitVerifier(this.muleContext).verifyCallOfMessageProcessor(MessageProcessorId.getName((String)messageProcessor)).ofNamespace(MessageProcessorId.getNamespace((String)messageProcessor)).withAttributes(this.createAttributes(attributes));
            if (times != null) {
                mockVerifier.times(times);
            } else if (atLeast != null) {
                mockVerifier.atLeast(atLeast);
            } else if (atMost != null) {
                mockVerifier.atMost(atMost);
            } else {
                mockVerifier.atLeastOnce();
            }
        }
        catch (AssertionError error) {
            AssertionError assertionException = new AssertionError((Object)this.getMessage(error, "Verify Processor Failed"));
            ((Throwable)((Object)assertionException)).setStackTrace(MunitCore.buildMuleStackTrace((MuleContext)this.muleContext).toArray(new StackTraceElement[0]));
            throw assertionException;
        }
    }

    public void outboundEndpoint(String address, Object returnPayload, Map<String, Object> returnInvocationProperties, Map<String, Object> returnInboundProperties, Map<String, Object> returnSessionProperties, Map<String, Object> returnOutboundProperties, List<NestedProcessor> assertions) {
        this.endpointMocker().expectEndpointWithAddress(address).withIncomingMessageSatisfying(this.createSpyAssertion(this.createMessageProcessorsFrom(assertions))).toReturn(this.createMuleMessageFrom(returnPayload, returnInboundProperties, returnOutboundProperties, returnSessionProperties, returnInvocationProperties));
    }

    public void setMuleContext(MuleContext muleContext) {
        this.muleContext = muleContext;
    }

    private MuleMessage createMuleMessageFrom(Object payload, Map<String, Object> inboundProperties, Map<String, Object> outboundProperties, Map<String, Object> sessionProperties, Map<String, Object> invocationProperties) {
        Object definedPayload = payload;
        if (payload == null) {
            definedPayload = NotDefinedPayload.getInstance();
        }
        DefaultMuleMessage message = new DefaultMuleMessage(definedPayload, this.muleContext);
        if (inboundProperties != null) {
            for (String property : inboundProperties.keySet()) {
                message.setInboundProperty(property, inboundProperties.get(property));
            }
        }
        if (outboundProperties != null) {
            for (String property : outboundProperties.keySet()) {
                message.setOutboundProperty(property, outboundProperties.get(property));
            }
        }
        if (invocationProperties != null) {
            for (String property : invocationProperties.keySet()) {
                message.setInvocationProperty(property, invocationProperties.get(property));
            }
        }
        return message;
    }

    private List<MessageProcessor> createMessageProcessorsFrom(List<NestedProcessor> assertions) {
        if (assertions == null) {
            return null;
        }
        ArrayList<MessageProcessor> mps = new ArrayList<MessageProcessor>();
        for (NestedProcessor nestedProcessor : assertions) {
            mps.add(new NestedMessageProcessor(nestedProcessor));
        }
        return mps;
    }

    private Map<String, Object> createAttributes(List<Attribute> attributes) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        if (attributes == null) {
            return attrs;
        }
        for (Attribute attr : attributes) {
            attrs.put(attr.getName(), attr.getWhereValue());
        }
        return attrs;
    }

    private List<SpyProcess> createSpyAssertion(List<MessageProcessor> messageProcessorsFrom) {
        ArrayList<SpyProcess> mps = new ArrayList<SpyProcess>();
        mps.add(this.createSpy(messageProcessorsFrom));
        return mps;
    }

    protected SpyProcess createSpy(final List<MessageProcessor> messageProcessorsFrom) {
        return new SpyProcess(){

            public void spy(MuleEvent event) throws MuleException {
                for (MessageProcessor mp : messageProcessorsFrom) {
                    mp.process(event);
                }
            }
        };
    }

    protected MessageProcessorMocker mocker() {
        return new MessageProcessorMocker(this.muleContext);
    }

    protected EndpointMocker endpointMocker() {
        return new EndpointMocker(this.muleContext);
    }

    protected MunitSpy spy() {
        return new MunitSpy(this.muleContext);
    }

    private String getMessage(AssertionError error, String defaultValue) {
        String message = ((Throwable)((Object)error)).getMessage();
        if (StringUtils.isEmpty((String)message)) {
            return defaultValue;
        }
        return message;
    }
}

