/**
 * Mule Development Kit
 * Copyright 2010-2011 (c) MuleSoft, Inc.  All rights reserved.  http://www.mulesoft.com
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * This file was automatically generated by the Mule Development Kit
 */
package org.mule.munit;

import org.mule.api.MuleContext;
import org.mule.api.NestedProcessor;
import org.mule.api.annotations.Configurable;
import org.mule.api.annotations.Module;
import org.mule.api.annotations.Processor;
import org.mule.api.annotations.param.Optional;
import org.mule.api.context.MuleContextAware;
import org.mule.api.processor.MessageProcessor;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.RuntimeBeanReference;
import org.springframework.beans.factory.support.ManagedList;
import org.springframework.beans.factory.support.RootBeanDefinition;

import java.util.ArrayList;
import java.util.List;

/**
 * <p>Module to mock message processors.</p>
 *
 * @author MuleSoft, Inc.
 */
@Module(name="mpmock", schemaVersion="1.0")
public class MPMockModule implements BeanFactoryPostProcessor, MuleContextAware
{
    /**
     * <p>Component that we want to mock.</p>
     */
    @Configurable
    private String of;
    
    private List<NestedProcessor> assertion;
    private Object response;
    private MuleContext context;


    public void setOf(String of) {
        
        this.of = of;
    }

    /**
     * <p> Define the assert process when the message processor is called </p>
     *
     * {@sample.xml ../../../doc/MPMock-connector.xml.sample mpmock:assert-payload}
     *
     * @param assertion The assertion process
     */
    @Processor
    public void assertPayload(@Optional List<NestedProcessor> assertion)
    {
        if ( assertion != null )
        {
            this.assertion =new ArrayList<NestedProcessor>();
        }
        else
        {
            this.assertion = assertion;
        }
    }


    /**
     * <p> Define what has to be returned when the message processor is called. </p>
     *
     * {@sample.xml ../../../doc/MPMock-connector.xml.sample mpmock:respond}
     *
     * @param response The response that has be returned
     */
    @Processor
    public void respond(Object response)
    {
        this.response = response;
    }


    public List<NestedProcessor> getAssertion() {
        return assertion;
    }

    public Object getResponse() {
        return response;
    }


    @Override
    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {

        String[] messageProcessorNames = beanFactory.getBeanNamesForType(MessageProcessor.class);
        for ( String mgProcessorName : messageProcessorNames)
        {
            if ( mgProcessorName.startsWith("." + of) )
            {
                String mpClass = beanFactory.getBean(mgProcessorName).getClass().getCanonicalName();
                String flowName = of.split(":")[0];
                BeanDefinition productionFlow = beanFactory.getBeanDefinition(flowName);
                ManagedList messageProcessors = messageProcessorsOf(productionFlow);

                for ( int i=0; i<messageProcessors.size(); i++ )
                {
                    Object mp = messageProcessors.get(i);

                    if ( mp instanceof RootBeanDefinition)
                    {
                        BeanDefinition beanDefinition = (BeanDefinition) mp;
                        if ( beanDefinition.getBeanClassName().equals(mpClass) )
                        {
                            messageProcessors.set(i, new MockedMessageProcessor(this));
                        }
                    }
                    if ( mp instanceof RuntimeBeanReference)
                    {
                        RuntimeBeanReference reference = (RuntimeBeanReference) mp;
                        if ( reference.getBeanName().startsWith(mgProcessorName))
                        {
                            messageProcessors.set(i, new MockedMessageProcessor(this));
                        }
                    }
                }
               
            }
        }

    }

    private ManagedList messageProcessorsOf(BeanDefinition productionFlow) {
        return (ManagedList) productionFlow.getPropertyValues().getPropertyValue("messageProcessors").getValue();
    }
    
    @Override
    public void setMuleContext(MuleContext context) {
        this.context = context;
    }
}
