/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.config;

import junit.framework.Assert;
import org.apache.commons.lang.StringUtils;
import org.mule.api.MessagingException;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.expression.ExpressionRuntimeException;
import org.mule.munit.common.MunitCore;
import org.mule.munit.config.MunitFlow;
import org.mule.munit.exception.MunitError;

public class MunitTestFlow
extends MunitFlow {
    private boolean ignore;
    private String expectExceptionThatSatisfies;

    public MunitTestFlow(String name, MuleContext muleContext) {
        super(name, muleContext);
        this.registerMpManager(muleContext);
    }

    public String getExpectException() {
        return this.expectExceptionThatSatisfies;
    }

    public void setExpectException(String expectException) {
        this.expectExceptionThatSatisfies = expectException;
    }

    public void setIgnore(boolean ignore) {
        this.ignore = ignore;
    }

    public boolean isIgnore() {
        return this.ignore;
    }

    private boolean expectException(Throwable t) {
        String className = t.getClass().getName();
        if (t instanceof MessagingException) {
            Throwable causeException;
            try {
                causeException = ((MessagingException)t).getCauseException();
            }
            catch (ClassCastException e) {
                causeException = t.getCause();
            }
            if (causeException != null) {
                className = causeException.getClass().getName();
            }
        }
        Assert.assertEquals((String)this.expectExceptionThatSatisfies, (String)className);
        return true;
    }

    public boolean expectException(Throwable t, MuleEvent event) {
        if (!StringUtils.isEmpty((String)this.expectExceptionThatSatisfies)) {
            ExpressionManager expressionManager = this.muleContext.getExpressionManager();
            if (expressionManager.isExpression(this.expectExceptionThatSatisfies)) {
                Boolean booleanExpressionResult;
                Object expressionResult;
                try {
                    expressionResult = expressionManager.evaluate(this.expectExceptionThatSatisfies, event);
                }
                catch (ExpressionRuntimeException e) {
                    throw new MunitError("Expect exception expression error. " + e.getMessage());
                }
                if (!Boolean.class.isAssignableFrom(expressionResult.getClass())) {
                    Assert.fail((String)"The exception does not match your MEL expression. Please make sure your expression matching returns a boolean value");
                }
                if (!(booleanExpressionResult = (Boolean)expressionResult).booleanValue()) {
                    Assert.fail((String)"The exception does not match your MEL expression");
                }
                return true;
            }
            return this.expectException(t);
        }
        return false;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MuleEvent process = super.process(event);
        return process;
    }

    private void registerMpManager(MuleContext muleContext) {
        MunitCore.registerManager((MuleContext)muleContext);
    }
}

