/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.config.spring;

import org.mule.munit.config.SetMessageProcessor;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SetDefinitionParser extends AbstractDefinitionParser {
    private static final String PAYLOAD_ATTR = "payload";

    public BeanDefinition parse(Element element, ParserContext parserContext) {
        BeanDefinitionBuilder builder = BeanDefinitionBuilder.rootBeanDefinition(SetMessageProcessor.class.getName());
        builder.setScope(BeanDefinition.SCOPE_PROTOTYPE);
        if (hasAttribute(element, PAYLOAD_ATTR)) {
            if (element.getAttribute(PAYLOAD_ATTR).startsWith("#")) {
                builder.addPropertyValue("payload", element.getAttribute(PAYLOAD_ATTR));
            } else {
                builder.addPropertyValue("payload", element.getAttribute(PAYLOAD_ATTR));
            }
        }
        parseMapAndSetProperty(element, builder, "invocationProperties", "invocation-properties", "invocation-property", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
        );
        parseMapAndSetProperty(element, builder, "inboundProperties", "inbound-properties", "inbound-property", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
        );
        parseMapAndSetProperty(element, builder, "sessionProperties", "session-properties", "session-property", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
        );
        parseMapAndSetProperty(element, builder, "outboundProperties", "outbound-properties", "outbound-property", new ParseDelegate<String>() {


                    public String parse(Element element) {
                        return element.getTextContent();
                    }

                }
        );
        BeanDefinition definition = builder.getBeanDefinition();
        setNoRecurseOnDefinition(definition);
        attachProcessorDefinition(parserContext, definition);
        return definition;
    }


}
