/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.endpoint;

import java.util.List;
import java.util.Map;
import org.mule.DefaultMuleMessage;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.mule.munit.common.endpoint.OutboundBehavior;
import org.mule.processor.AbstractRedeliveryPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockOutboundEndpoint
implements OutboundEndpoint {
    private OutboundEndpoint realEndpoint;

    public MockOutboundEndpoint(OutboundEndpoint realEndpoint) {
        this.realEndpoint = realEndpoint;
    }

    public List<String> getResponseProperties() {
        return null;
    }

    public EndpointURI getEndpointURI() {
        return null;
    }

    public String getAddress() {
        return null;
    }

    public String getEncoding() {
        return null;
    }

    public Connector getConnector() {
        return null;
    }

    public List<Transformer> getTransformers() {
        return null;
    }

    public List<Transformer> getResponseTransformers() {
        return null;
    }

    public Map getProperties() {
        return null;
    }

    public Object getProperty(Object key) {
        return null;
    }

    public String getProtocol() {
        return null;
    }

    public boolean isReadOnly() {
        return false;
    }

    public TransactionConfig getTransactionConfig() {
        return null;
    }

    public Filter getFilter() {
        return null;
    }

    public boolean isDeleteUnacceptedMessages() {
        return false;
    }

    public EndpointSecurityFilter getSecurityFilter() {
        return null;
    }

    public EndpointMessageProcessorChainFactory getMessageProcessorsFactory() {
        return null;
    }

    public List<MessageProcessor> getMessageProcessors() {
        return null;
    }

    public List<MessageProcessor> getResponseMessageProcessors() {
        return null;
    }

    public MessageExchangePattern getExchangePattern() {
        return this.realEndpoint.getExchangePattern();
    }

    public int getResponseTimeout() {
        return 0;
    }

    public String getInitialState() {
        return null;
    }

    public MuleContext getMuleContext() {
        return null;
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return null;
    }

    public String getEndpointBuilderName() {
        return null;
    }

    public boolean isProtocolSupported(String protocol) {
        return false;
    }

    public String getMimeType() {
        return null;
    }

    public AbstractRedeliveryPolicy getRedeliveryPolicy() {
        return null;
    }

    public boolean isDisableTransportTransformer() {
        return false;
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MockEndpointManager manager = (MockEndpointManager)this.getEndpointManager(event);
        String address = this.realAddressAsExpression();
        ExpressionManager expressionManager = event.getMuleContext().getExpressionManager();
        if (expressionManager.isValidExpression(address)) {
            String realAddress = (String)expressionManager.evaluate(address, event);
            OutboundBehavior behavior = manager.getBehaviorFor(realAddress);
            if (behavior == null) {
                return this.realEndpoint.process(event);
            }
            MunitUtils.verifyAssertions(event, behavior.getAssertions());
            MunitUtils.copyMessage((DefaultMuleMessage)behavior.getMessage(), (DefaultMuleMessage)event.getMessage());
        }
        return event;
    }

    private String realAddressAsExpression() {
        return "#[string:" + this.realEndpoint.getAddress() + "]";
    }

    private Object getEndpointManager(MuleEvent event) {
        return event.getMuleContext().getRegistry().lookupObject("_muleEndpointFactory");
    }

    public String getName() {
        return "Mocked Endpoint";
    }
}

