/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mocking;

import java.util.List;
import java.util.Map;
import junit.framework.Assert;
import org.mule.api.MuleContext;
import org.mule.modules.interceptor.processors.MessageProcessorCall;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.munit.common.mocking.MunitMockingTool;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitVerifier
extends MunitMockingTool {
    public MunitVerifier(MuleContext muleContext) {
        super(muleContext);
    }

    public MunitVerifier verifyCallOfMessageProcessor(String name) {
        this.messageProcessorName = name;
        return this;
    }

    public MunitVerifier ofNamespace(String namespace) {
        this.messageProcessorNamespace = namespace;
        return this;
    }

    public void times(Integer times) {
        List<MessageProcessorCall> executedCalls = this.getExecutedCalls();
        if (executedCalls.size() != times.intValue()) {
            Assert.fail((String)("On " + this.getFullName() + ".Expected " + times + " but got " + executedCalls.size() + " calls"));
        }
    }

    public void atLeast(Integer atLeast) {
        this.checkValidQuery();
        List<MessageProcessorCall> executedCalls = this.getExecutedCalls();
        if (executedCalls.size() < atLeast) {
            Assert.fail((String)("On " + this.getFullName() + ".Expected at least " + atLeast + " but got " + executedCalls.size() + " calls"));
        }
    }

    public void atMost(Integer atMost) {
        this.checkValidQuery();
        List<MessageProcessorCall> executedCalls = this.getExecutedCalls();
        if (executedCalls.size() > atMost) {
            Assert.fail((String)("On " + this.getFullName() + ".Expected at most " + atMost + " but got " + executedCalls.size() + " calls"));
        }
    }

    public void atLeastOnce() {
        this.checkValidQuery();
        List<MessageProcessorCall> executedCalls = this.getExecutedCalls();
        if (executedCalls.isEmpty()) {
            Assert.fail((String)("On " + this.getFullName() + ".It was never called"));
        }
    }

    private List<MessageProcessorCall> getExecutedCalls() {
        return this.getManager().findCallsFor(new MessageProcessorId(this.messageProcessorName, this.messageProcessorNamespace), this.messageProcessorAttributes);
    }

    public MunitVerifier withAttributes(Map<String, Object> attributes) {
        this.messageProcessorAttributes = attributes;
        return this;
    }
}

