/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.mp;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.mule.modules.interceptor.processors.MessageProcessorCall;
import org.mule.modules.interceptor.processors.MessageProcessorId;
import org.mule.modules.interceptor.processors.MessageProcessorManager;
import org.mule.munit.common.mp.MunitMessageProcessorCall;
import org.mule.munit.common.mp.SpyAssertion;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockedMessageProcessorManager
extends MessageProcessorManager {
    public static String ID = "_muleMockMpManager";
    protected List<MunitMessageProcessorCall> calls = new LinkedList<MunitMessageProcessorCall>();
    protected List<SpyAssertion> beforeCallSpyAssertions = new LinkedList<SpyAssertion>();
    protected List<SpyAssertion> afterCallSpyAssertions = new LinkedList<SpyAssertion>();

    public void reset() {
        this.behaviors.clear();
        this.calls.clear();
        this.beforeCallSpyAssertions.clear();
        this.afterCallSpyAssertions.clear();
    }

    public List<MessageProcessorCall> findCallsFor(MessageProcessorId mpId, Map<String, Object> attributesMatchers) {
        ArrayList<MessageProcessorCall> expected = new ArrayList<MessageProcessorCall>();
        MessageProcessorCall matchingCall = new MessageProcessorCall(mpId);
        matchingCall.setAttributes(attributesMatchers);
        for (MunitMessageProcessorCall call : this.calls) {
            if (matchingCall.matchingWeight((MessageProcessorCall)call) < 0) continue;
            expected.add(call);
        }
        return expected;
    }

    public SpyAssertion getBetterMatchingBeforeSpyAssertion(MessageProcessorCall messageProcessorCall) {
        return (SpyAssertion)this.getBetterMatchingAction(messageProcessorCall, this.beforeCallSpyAssertions);
    }

    public SpyAssertion getBetterMatchingAfterSpyAssertion(MessageProcessorCall messageProcessorCall) {
        return (SpyAssertion)this.getBetterMatchingAction(messageProcessorCall, this.afterCallSpyAssertions);
    }

    public synchronized void addCall(MunitMessageProcessorCall call) {
        this.calls.add(call);
    }

    public synchronized void addBeforeCallSpyAssertion(SpyAssertion spyAssertion) {
        this.beforeCallSpyAssertions.add(spyAssertion);
    }

    public synchronized void addAfterCallSpyAssertion(SpyAssertion spyAssertion) {
        this.afterCallSpyAssertions.add(spyAssertion);
    }

    public List<MunitMessageProcessorCall> getCalls() {
        return new LinkedList<MunitMessageProcessorCall>(this.calls);
    }
}

