/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.common.endpoint;

import java.util.List;
import java.util.Map;
import org.mule.MessageExchangePattern;
import org.mule.api.MuleContext;
import org.mule.api.MuleEvent;
import org.mule.api.MuleException;
import org.mule.api.endpoint.EndpointMessageProcessorChainFactory;
import org.mule.api.endpoint.EndpointURI;
import org.mule.api.endpoint.OutboundEndpoint;
import org.mule.api.expression.ExpressionManager;
import org.mule.api.processor.MessageProcessor;
import org.mule.api.retry.RetryPolicyTemplate;
import org.mule.api.routing.filter.Filter;
import org.mule.api.security.EndpointSecurityFilter;
import org.mule.api.transaction.TransactionConfig;
import org.mule.api.transformer.Transformer;
import org.mule.api.transport.Connector;
import org.mule.munit.common.MunitUtils;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.mule.munit.common.endpoint.OutboundBehavior;
import org.mule.processor.AbstractRedeliveryPolicy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MockOutboundEndpoint
implements OutboundEndpoint {
    private OutboundEndpoint realEndpoint;

    public MockOutboundEndpoint(OutboundEndpoint realEndpoint) {
        this.realEndpoint = realEndpoint;
    }

    public List<String> getResponseProperties() {
        return this.realEndpoint.getResponseProperties();
    }

    public EndpointURI getEndpointURI() {
        return this.realEndpoint.getEndpointURI();
    }

    public String getAddress() {
        return this.realEndpoint.getAddress();
    }

    public String getEncoding() {
        return this.realEndpoint.getEncoding();
    }

    public Connector getConnector() {
        return this.realEndpoint.getConnector();
    }

    public List<Transformer> getTransformers() {
        return this.realEndpoint.getTransformers();
    }

    public List<Transformer> getResponseTransformers() {
        return this.realEndpoint.getResponseTransformers();
    }

    public Map getProperties() {
        return this.realEndpoint.getProperties();
    }

    public Object getProperty(Object key) {
        return this.realEndpoint.getProperty(key);
    }

    public String getProtocol() {
        return this.realEndpoint.getProtocol();
    }

    public boolean isReadOnly() {
        return this.realEndpoint.isReadOnly();
    }

    public TransactionConfig getTransactionConfig() {
        return this.realEndpoint.getTransactionConfig();
    }

    public Filter getFilter() {
        return this.realEndpoint.getFilter();
    }

    public boolean isDeleteUnacceptedMessages() {
        return this.realEndpoint.isDeleteUnacceptedMessages();
    }

    public EndpointSecurityFilter getSecurityFilter() {
        return this.realEndpoint.getSecurityFilter();
    }

    public EndpointMessageProcessorChainFactory getMessageProcessorsFactory() {
        return this.realEndpoint.getMessageProcessorsFactory();
    }

    public List<MessageProcessor> getMessageProcessors() {
        return this.realEndpoint.getMessageProcessors();
    }

    public List<MessageProcessor> getResponseMessageProcessors() {
        return this.realEndpoint.getResponseMessageProcessors();
    }

    public MessageExchangePattern getExchangePattern() {
        return this.realEndpoint.getExchangePattern();
    }

    public int getResponseTimeout() {
        return this.realEndpoint.getResponseTimeout();
    }

    public String getInitialState() {
        return this.realEndpoint.getInitialState();
    }

    public MuleContext getMuleContext() {
        return this.realEndpoint.getMuleContext();
    }

    public RetryPolicyTemplate getRetryPolicyTemplate() {
        return this.realEndpoint.getRetryPolicyTemplate();
    }

    public String getEndpointBuilderName() {
        return this.realEndpoint.getEndpointBuilderName();
    }

    public boolean isProtocolSupported(String protocol) {
        return this.realEndpoint.isProtocolSupported(protocol);
    }

    public String getMimeType() {
        return this.realEndpoint.getMimeType();
    }

    public AbstractRedeliveryPolicy getRedeliveryPolicy() {
        return this.realEndpoint.getRedeliveryPolicy();
    }

    public boolean isDisableTransportTransformer() {
        return this.realEndpoint.isDisableTransportTransformer();
    }

    public MuleEvent process(MuleEvent event) throws MuleException {
        MockEndpointManager manager = (MockEndpointManager)this.getEndpointManager(event);
        String address = this.realAddressAsExpression();
        ExpressionManager expressionManager = event.getMuleContext().getExpressionManager();
        if (expressionManager.isValidExpression(address)) {
            String realAddress = (String)expressionManager.evaluate(address, event);
            OutboundBehavior behavior = manager.getBehaviorFor(realAddress);
            if (behavior == null) {
                return this.realEndpoint.process(event);
            }
            if (behavior.getException() != null) {
                throw behavior.getException();
            }
            MunitUtils.verifyAssertions(event, behavior.getAssertions());
            if (behavior.getMuleMessageTransformer() != null) {
                event.setMessage(behavior.getMuleMessageTransformer().transform(event.getMessage()));
            }
        }
        return event;
    }

    private String realAddressAsExpression() {
        return "#[string:" + this.realEndpoint.getAddress() + "]";
    }

    private Object getEndpointManager(MuleEvent event) {
        return event.getMuleContext().getRegistry().lookupObject("_muleEndpointFactory");
    }

    public String getName() {
        return this.realEndpoint.getName();
    }
}

