/*
 * Decompiled with CFR 0.152.
 */
package org.mule;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.project.MavenProject;
import org.mule.munit.test.MunitTestRunner;
import org.mule.munit.test.result.MunitResult;
import org.mule.munit.test.result.SuiteResult;
import org.mule.munit.test.result.notification.NotificationListener;
import org.mule.munit.test.result.notification.StreamNotificationListener;

public class MUnitMojo
extends AbstractMojo {
    protected MavenProject project;
    protected String munittest;
    protected List<String> classpathElements;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute() throws MojoExecutionException {
        if (!"true".equals(System.getProperty("skipTests"))) {
            List testResources = this.project.getTestResources();
            for (Object o : testResources) {
                Resource testResource = (Resource)o;
                testResource.getTargetPath();
            }
            Thread t = Thread.currentThread();
            ClassLoader old = t.getContextClassLoader();
            try {
                ArrayList<SuiteResult> results = new ArrayList<SuiteResult>();
                t.setContextClassLoader(this.getClassPath(this.makeClassPath()));
                File testFolder = new File(this.project.getBasedir(), "src/test/munit");
                for (File file : testFolder.listFiles()) {
                    String fileName = file.getName();
                    if (!fileName.endsWith(".xml") || !this.validateFilter(fileName)) continue;
                    System.out.println();
                    System.out.println("===========  Running " + fileName + " test ===========");
                    System.out.println();
                    results.add(this.buildRunnerFor(fileName).run());
                }
                this.show(results);
            }
            catch (MalformedURLException e) {
                e.printStackTrace();
            }
            finally {
                t.setContextClassLoader(old);
            }
        }
    }

    private void show(List<SuiteResult> results) throws MojoExecutionException {
        boolean success = true;
        System.out.println();
        System.out.println("\t=====================================");
        System.out.println("\t  Munit Summary                      ");
        System.out.println("\t=====================================");
        for (SuiteResult run : results) {
            List failingTests = run.getFailingTests();
            List errorTests = run.getErrorTests();
            System.out.println("\t >> " + run.getTestName() + " test result: Errors: " + errorTests.size() + ", Failures:" + failingTests.size());
            this.showFailures(failingTests);
            this.showError(errorTests);
            if (failingTests.isEmpty() && errorTests.isEmpty()) continue;
            success = false;
        }
        if (!success) {
            throw new MojoExecutionException("MUnit Tests Failed!!!");
        }
    }

    private void showFailures(List<MunitResult> failingTests) {
        if (!failingTests.isEmpty()) {
            for (MunitResult result : failingTests) {
                System.out.println("\t\t ---" + result.getTestName() + " <<< FAILED");
            }
        }
    }

    private void showError(List<MunitResult> errorTests) {
        if (!errorTests.isEmpty()) {
            for (MunitResult result : errorTests) {
                System.out.println("\t\t ---" + result.getTestName() + " <<< ERROR");
            }
        }
    }

    private MunitTestRunner buildRunnerFor(String fileName) {
        MunitTestRunner runner = new MunitTestRunner(fileName);
        runner.setNotificationListener((NotificationListener)new StreamNotificationListener(System.out));
        return runner;
    }

    private boolean validateFilter(String fileName) {
        if (this.munittest == null) {
            return true;
        }
        return fileName.matches(this.munittest);
    }

    public URLClassLoader getClassPath(List<URL> classpath) {
        return new URLClassLoader(classpath.toArray(new URL[classpath.size()]), ((Object)((Object)this)).getClass().getClassLoader());
    }

    private List<URL> makeClassPath() throws MalformedURLException {
        ArrayList<URL> urls = new ArrayList<URL>(this.classpathElements.size());
        for (String e : this.classpathElements) {
            urls.add(new File(e).toURL());
        }
        return urls;
    }
}

