/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule.context;

import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import org.mule.api.transport.Connector;
import org.mule.construct.Flow;
import org.mule.modules.interceptor.connectors.ConnectorMethodInterceptorFactory;
import org.mule.munit.common.endpoint.MockEndpointManager;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.beans.factory.support.RootBeanDefinition;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MunitApplicationContextPostProcessor {
    private static Logger logger = Logger.getLogger("Bean definition Processor");
    protected boolean mockInbounds = true;
    protected boolean mockConnectors = true;
    protected List<String> mockingExcludedFlows = new ArrayList<String>();

    public void setMockInbounds(boolean mockInbounds) {
        this.mockInbounds = mockInbounds;
    }

    public void setMockingExcludedFlows(List<String> mockingExcludedFlows) {
        this.mockingExcludedFlows = mockingExcludedFlows;
    }

    public boolean isMockInbounds() {
        return this.mockInbounds;
    }

    public boolean isMockConnectors() {
        return this.mockConnectors;
    }

    public void setMockConnectors(boolean mockConnectors) {
        this.mockConnectors = mockConnectors;
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        if (this.isMockInbounds() || this.isMockConnectors()) {
            String[] beanDefinitionNames;
            String[] names = beanFactory.getBeanDefinitionNames();
            for (String name : beanDefinitionNames = names == null ? new String[]{} : names) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(name);
                if (!Flow.class.getName().equals(beanDefinition.getBeanClassName()) || this.mockingExcludedFlows.contains(name)) continue;
                beanDefinition.getPropertyValues().removePropertyValue("messageSource");
            }
        }
        this.changeEndpointFactory(beanFactory);
        this.mockConnectors(beanFactory);
    }

    private void changeEndpointFactory(ConfigurableListableBeanFactory beanFactory) {
        GenericBeanDefinition endpointFactory = (GenericBeanDefinition)beanFactory.getBeanDefinition("_muleEndpointFactory");
        AbstractBeanDefinition abstractBeanDefinition = endpointFactory.cloneBeanDefinition();
        MutablePropertyValues propertyValues = new MutablePropertyValues();
        propertyValues.add("defaultFactory", (Object)abstractBeanDefinition);
        endpointFactory.setPropertyValues(propertyValues);
        endpointFactory.setBeanClassName(MockEndpointManager.class.getCanonicalName());
    }

    private void mockConnectors(ConfigurableListableBeanFactory beanFactory) {
        String[] beanNamesForType;
        if (this.isMockConnectors() && (beanNamesForType = beanFactory.getBeanDefinitionNames()) != null) {
            for (String beanName : beanNamesForType) {
                BeanDefinition beanDefinition = beanFactory.getBeanDefinition(beanName);
                try {
                    if (!Connector.class.isAssignableFrom(Class.forName(beanDefinition.getBeanClassName()))) continue;
                    RootBeanDefinition rootBeanDefinition = (RootBeanDefinition)RootBeanDefinition.class.cast(beanDefinition);
                    if (beanDefinition.getFactoryMethodName() == null) {
                        ConnectorMethodInterceptorFactory.addFactoryDefinitionTo((AbstractBeanDefinition)rootBeanDefinition).withConstructorArguments(new Object[]{rootBeanDefinition.getBeanClass()});
                        continue;
                    }
                    logger.info("The connector " + beanName + " cannot be mocked as it already has a factory method");
                }
                catch (ClassNotFoundException e) {
                    logger.info("Could not create Class for connector matching");
                }
            }
        }
    }
}

