/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.output;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.mule.munit.runner.output.ConsolePrinter;
import org.mule.munit.runner.output.LogPrinter;
import org.mule.munit.runner.output.OutputPrinter;
import org.mule.munit.runner.output.TestOutputHandler;

public class DefaultOutputHandler
implements TestOutputHandler {
    public static String OUTPUT_FOLDER_PROPERTY = "munit.output.folder";
    private List<OutputPrinter> printers = new ArrayList<OutputPrinter>();

    public DefaultOutputHandler() {
        if (System.getProperty(OUTPUT_FOLDER_PROPERTY) != null) {
            this.printers.add(new LogPrinter());
        }
        this.printers.add(new ConsolePrinter());
    }

    public void printDescription(String name, String description) {
        String text = "Running " + name;
        this.print(text);
    }

    public void printTestName(String suiteName) {
        String title = StringUtils.repeat((String)"=", (int)(40 + FilenameUtils.getName((String)suiteName).length()));
        this.print(title);
        this.print("===========  Running  " + FilenameUtils.getName((String)suiteName) + "  test ===========");
        this.print(title);
    }

    private void print(String text) {
        for (OutputPrinter printer : this.printers) {
            printer.print(text);
        }
    }
}

