/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule.context;

import java.io.IOException;
import java.util.List;
import org.mule.api.MuleContext;
import org.mule.config.ConfigResource;
import org.mule.config.spring.MissingParserProblemReporter;
import org.mule.config.spring.MuleArtifactContext;
import org.mule.modules.interceptor.connectors.ConnectorMethodInterceptorFactory;
import org.mule.munit.common.endpoint.MunitSpringFactoryPostProcessor;
import org.mule.munit.common.mp.MunitMessageProcessorInterceptorFactory;
import org.mule.munit.runner.mule.context.MockingConfiguration;
import org.mule.munit.runner.mule.context.MunitApplicationContextPostProcessor;
import org.mule.munit.runner.mule.context.MunitBeanDefinitionDocumentReader;
import org.mule.munit.runner.mule.context.MunitXmlBeanDefinitionReader;
import org.springframework.beans.BeansException;
import org.springframework.beans.MutablePropertyValues;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.parsing.ProblemReporter;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.RootBeanDefinition;

public class MunitApplicationContext
extends MuleArtifactContext {
    public static final String MUNIT_FACTORY_POST_PROCESSOR = "___MunitSpringFactoryPostProcessor";
    public static final String MOCK_INBOUNDS_PROPERTY_NAME = "mockInbounds";
    public static final String MOCK_CONNECTORS_PROPERTY_NAME = "mockConnectors";
    public static final String MOCKING_EXCLUDED_FLOWS_PROPERTY_NAME = "mockingExcludedFlows";
    private MockingConfiguration configuration;

    public MunitApplicationContext(MuleContext muleContext, ConfigResource[] configResources, MockingConfiguration configuration) throws BeansException {
        super(muleContext, configResources);
        this.configuration = configuration;
    }

    protected void loadBeanDefinitions(DefaultListableBeanFactory beanFactory) throws IOException {
        MunitXmlBeanDefinitionReader beanDefinitionReader = this.getMunitXmlBeanDefinitionReader(beanFactory);
        beanDefinitionReader.setDocumentReaderClass(MunitBeanDefinitionDocumentReader.class);
        beanFactory.registerBeanDefinition("__messageProcessorEnhancerFactory", (BeanDefinition)new RootBeanDefinition(MunitMessageProcessorInterceptorFactory.class));
        beanFactory.registerBeanDefinition(ConnectorMethodInterceptorFactory.ID, (BeanDefinition)new RootBeanDefinition(ConnectorMethodInterceptorFactory.class));
        beanDefinitionReader.setProblemReporter((ProblemReporter)new MissingParserProblemReporter());
        if (this.configuration != null) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition();
            beanDefinition.setBeanClass(MunitSpringFactoryPostProcessor.class);
            MutablePropertyValues propertyValues = new MutablePropertyValues();
            propertyValues.add(MOCK_INBOUNDS_PROPERTY_NAME, (Object)this.configuration.isMockInbounds());
            propertyValues.add(MOCK_CONNECTORS_PROPERTY_NAME, (Object)this.configuration.isMockConnectors());
            propertyValues.add(MOCKING_EXCLUDED_FLOWS_PROPERTY_NAME, this.configuration.getMockingExcludedFlows());
            beanDefinition.setPropertyValues(propertyValues);
            beanFactory.registerBeanDefinition(MUNIT_FACTORY_POST_PROCESSOR, (BeanDefinition)beanDefinition);
        }
        MunitApplicationContext.getCurrentMuleContext().set(this.getMuleContext());
        beanDefinitionReader.loadBeanDefinitions(this.getConfigResources());
        MunitApplicationContext.getCurrentMuleContext().remove();
    }

    protected MunitXmlBeanDefinitionReader getMunitXmlBeanDefinitionReader(DefaultListableBeanFactory beanFactory) {
        return new MunitXmlBeanDefinitionReader((BeanDefinitionRegistry)beanFactory);
    }

    protected void prepareBeanFactory(ConfigurableListableBeanFactory beanFactory) {
        super.prepareBeanFactory(beanFactory);
        BeanDefinition beanDefinition = beanFactory.getBeanDefinition(MUNIT_FACTORY_POST_PROCESSOR);
        MutablePropertyValues propertyValues = beanDefinition.getPropertyValues();
        MunitApplicationContextPostProcessor postProcessor = new MunitApplicationContextPostProcessor();
        postProcessor.setMockConnectors((Boolean)propertyValues.getPropertyValue(MOCK_CONNECTORS_PROPERTY_NAME).getValue());
        postProcessor.setMockInbounds((Boolean)propertyValues.getPropertyValue(MOCK_INBOUNDS_PROPERTY_NAME).getValue());
        postProcessor.setMockingExcludedFlows((List)propertyValues.getPropertyValue(MOCKING_EXCLUDED_FLOWS_PROPERTY_NAME).getValue());
        postProcessor.postProcessBeanFactory(beanFactory);
    }
}

