/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule.result;

import java.util.ArrayList;
import java.util.List;
import org.mule.munit.runner.mule.result.MunitResult;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SuiteResult
implements MunitResult {
    private List<MunitResult> results = new ArrayList<MunitResult>();
    private String name;

    public SuiteResult(String name) {
        this.name = name;
    }

    @Override
    public boolean hasSucceeded() {
        for (MunitResult result : this.results) {
            if (result.hasSucceeded()) continue;
            return false;
        }
        return true;
    }

    @Override
    public int getNumberOfFailures() {
        int failures = 0;
        for (MunitResult result : this.results) {
            failures += result.getNumberOfFailures();
        }
        return failures;
    }

    @Override
    public int getNumberOfErrors() {
        int errors = 0;
        for (MunitResult result : this.results) {
            errors += result.getNumberOfErrors();
        }
        return errors;
    }

    @Override
    public int getNumberOfTests() {
        return this.results.size();
    }

    @Override
    public float getTime() {
        float total = 0.0f;
        for (MunitResult result : this.results) {
            total += result.getTime();
        }
        return total;
    }

    @Override
    public int getNumberOfSkipped() {
        int skipped = 0;
        for (MunitResult result : this.results) {
            skipped += result.getNumberOfSkipped();
        }
        return skipped;
    }

    @Override
    public String getTestName() {
        return this.name;
    }

    public List<MunitResult> getFailingTests() {
        ArrayList<MunitResult> failingTests = new ArrayList<MunitResult>();
        for (MunitResult result : this.results) {
            if (result.getNumberOfFailures() <= 0) continue;
            failingTests.add(result);
        }
        return failingTests;
    }

    public List<MunitResult> getErrorTests() {
        ArrayList<MunitResult> errorTests = new ArrayList<MunitResult>();
        for (MunitResult result : this.results) {
            if (result.getNumberOfErrors() <= 0) continue;
            errorTests.add(result);
        }
        return errorTests;
    }

    public void add(MunitResult result) {
        this.results.add(result);
    }
}

