/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.mule.context;

import org.mule.api.MuleContext;
import org.mule.api.config.ConfigurationException;
import org.mule.config.ConfigResource;
import org.mule.config.spring.*;

import org.springframework.context.ApplicationContext;

/**
 * <p>
 * Override of the {@link SpringXmlConfigurationBuilder} for Munit. It just overrides the creation of the
 * {@link ApplicationContext} in order to create an {@link MunitApplicationContext}
 * </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public class MunitSpringXmlConfigurationBuilder extends SpringXmlConfigurationBuilder
{

    private MockingConfiguration configuration;

    public MunitSpringXmlConfigurationBuilder(String configResources, MockingConfiguration configuration) throws ConfigurationException
    {
        super(configResources);
        this.configuration = configuration;
    }

    protected ApplicationContext doCreateApplicationContext(MuleContext muleContext, ConfigResource[] configResources, OptionalObjectsController optionalObjectsController) {
        return new MunitApplicationContext(muleContext, configResources, configuration);
    }
}
