/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.output;


/**
 * <p>Defines how the stage notification of the test will be handled </p>
 *
 * @author Mulesoft Inc.
 * @since 3.3.2
 */
public interface TestOutputHandler
{

    /**
     * <p>Prints the MUnit flow information</p>
     *
     * @param name        The name of the Munit flow (before-test,after-test,before-suite,after-suite,test)
     * @param description The flow description
     */
    void printDescription(String name, String description);

    void printTestName(String suiteName);
}
