/*
 * Copyright (c) 2015 MuleSoft, Inc. This software is protected under international
 * copyright law. All use of this software is subject to MuleSoft's Master Subscription
 * Agreement (or other master license agreement) separately entered into in writing between
 * you and MuleSoft. If such an agreement is not in place, you may not use the software.
 */
package org.mule.munit.runner.remote;

import org.mule.munit.runner.mule.MunitTest;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.TestResult;
import org.mule.munit.runner.mule.result.notification.Notification;
import org.mule.munit.runner.mule.result.notification.NotificationListener;

import java.io.IOException;
import java.io.ObjectOutput;

/**
 * @author Mulesoft Inc.
 * @since 3.6.0
 */
public class RemoteRunnerNotificationListener implements NotificationListener {

    private ObjectOutput out;

    public RemoteRunnerNotificationListener(ObjectOutput out) {
        this.out = out;
    }

    public void notifyRuntimeStartFailure(Notification notification) {
        sendMessage(MessageBuilder.buildRuntimeStartFailureMessage(notification.getFullMessage()));
    }

    public void notifyNumberOfTest(int numberOfTests) {
        sendMessage(MessageBuilder.buildNuberOfTestsMessage(String.valueOf(numberOfTests)));
    }

    public void notifyStartOf(MunitTest test) {
        sendMessage(MessageBuilder.buildNewTestMessage(test.getName()));
    }

    public void notify(TestResult testResult) {
        if (testResult.getError() != null) {
            sendMessage(MessageBuilder.buildTestErroMessage(testResult.getTestName(), testResult.getError().getFullMessage()));
        } else if (testResult.getFailure() != null) {
            sendMessage(MessageBuilder.buildTestFailureMessage(testResult.getTestName(), testResult.getFailure().getFullMessage()));
        } else {
            sendMessage(MessageBuilder.buildTestFinishedMessage(testResult.getTestName()));
        }

    }

    @Override
    public void notifyIgnored(TestResult testResult) {
        sendMessage(MessageBuilder.buildTestIgnoredMessage(testResult.getName()));
    }

    @Override
    public void notifyEnd(SuiteResult result) {
        // DO NOTHING
        // TODO: FIX THIS
    }

    //TODO: shouldn't this be the default implementation of notifyEnd?
    public void notifyTestRunEnd(String testFullPath) {
        sendMessage(MessageBuilder.buildTestRunFinishedMessage(testFullPath));
    }

    private void sendMessage(String message) {
        try {
            out.writeObject(message);
            out.flush();
        } catch (IOException e) {
            // TODO Auto-generated catch block
            e.printStackTrace();
        }
    }


}
