/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule;

import org.mule.api.MuleContext;
import org.mule.munit.runner.MuleContextManager;
import org.mule.munit.runner.MunitRunner;
import org.mule.munit.runner.mule.MunitSuite;
import org.mule.munit.runner.mule.MunitSuiteBuilder;
import org.mule.munit.runner.mule.result.SuiteResult;
import org.mule.munit.runner.mule.result.notification.NotificationListener;
import org.mule.munit.runner.mule.result.output.DefaultOutputHandler;
import org.mule.munit.runner.mule.result.output.TestOutputHandler;

public class MunitSuiteRunner {
    private MuleContext muleContext;
    private MunitSuite suite;
    private TestOutputHandler handler = new DefaultOutputHandler();
    private MuleContextManager muleContextManager = new MuleContextManager(null);

    public MunitSuiteRunner(String resources) {
        try {
            this.muleContext = this.muleContextManager.startMule(resources);
            this.suite = (MunitSuite)new MunitSuiteBuilder(this.muleContext, this.handler).build(resources);
        }
        catch (Exception e) {
            this.muleContextManager.killMule(this.muleContext);
            throw new RuntimeException(e);
        }
    }

    public SuiteResult run() {
        return (SuiteResult)new MunitRunner<SuiteResult>(this.handler, this.muleContextManager, this.muleContext){

            @Override
            protected SuiteResult runSuite() throws Exception {
                return MunitSuiteRunner.this.suite.run();
            }
        }.run();
    }

    public void setNotificationListener(NotificationListener notificationListener) {
        this.suite.setNotificationListener(notificationListener);
    }

    public int getNumberOfTests() {
        return this.suite.getNumberOfTests();
    }
}

