/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner;

import java.io.IOException;
import java.util.ArrayList;
import javax.resource.spi.work.WorkListener;
import org.apache.log4j.Appender;
import org.apache.log4j.FileAppender;
import org.apache.log4j.Layout;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.SimpleLayout;
import org.mule.api.MuleContext;
import org.mule.api.MuleException;
import org.mule.api.config.ConfigurationBuilder;
import org.mule.api.context.MuleContextBuilder;
import org.mule.config.DefaultMuleConfiguration;
import org.mule.config.builders.SimpleConfigurationBuilder;
import org.mule.context.DefaultMuleContextBuilder;
import org.mule.context.DefaultMuleContextFactory;
import org.mule.munit.common.MunitCore;
import org.mule.munit.runner.mule.context.MockingConfiguration;
import org.mule.munit.runner.mule.context.MunitSpringXmlConfigurationBuilder;
import org.mule.munit.runner.output.DefaultOutputHandler;
import org.mule.tck.TestingWorkListener;
import org.mule.util.ClassUtils;

public class MuleContextManager {
    public static final String CLASSNAME_ANNOTATIONS_CONFIG_BUILDER = "org.mule.org.mule.munit.config.AnnotationsConfigurationBuilder";
    private MockingConfiguration configuration;

    public MuleContextManager(MockingConfiguration configuration) {
        this.configuration = configuration;
    }

    public MuleContext startMule(String resources) throws Exception {
        MuleContext context = this.createMule(resources);
        context.start();
        MunitCore.setMuleContext((MuleContext)context);
        return context;
    }

    public void killMule(MuleContext muleContext) {
        try {
            if (muleContext != null && !muleContext.isStopped()) {
                muleContext.stop();
            }
        }
        catch (MuleException muleException) {
            // empty catch block
        }
        if (muleContext != null && !muleContext.isDisposed()) {
            muleContext.dispose();
        }
    }

    private MuleContext createMule(String resources) throws Exception {
        this.defineLogOutput(resources);
        DefaultMuleContextFactory muleContextFactory = new DefaultMuleContextFactory();
        ArrayList<Object> builders = new ArrayList<Object>();
        builders.add(new SimpleConfigurationBuilder(null));
        if (ClassUtils.isClassOnPath((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, this.getClass())) {
            builders.add((ConfigurationBuilder)ClassUtils.instanciateClass((String)CLASSNAME_ANNOTATIONS_CONFIG_BUILDER, (Object[])ClassUtils.NO_ARGS, this.getClass()));
        }
        builders.add(this.getBuilder(resources));
        DefaultMuleContextBuilder contextBuilder = new DefaultMuleContextBuilder();
        this.configureMuleContext((MuleContextBuilder)contextBuilder);
        MuleContext context = muleContextFactory.createMuleContext(builders, (MuleContextBuilder)contextBuilder);
        ((DefaultMuleConfiguration)context.getConfiguration()).setShutdownTimeout(0);
        return context;
    }

    private void defineLogOutput(String resources) throws IOException {
        String path = System.getProperty(DefaultOutputHandler.OUTPUT_FOLDER_PROPERTY);
        if (path != null) {
            String name = resources.replace(".xml", "");
            Logger logger = Logger.getRootLogger();
            logger.removeAllAppenders();
            logger.addAppender((Appender)new FileAppender((Layout)new SimpleLayout(), String.format(path, name)));
            logger.setLevel(Level.INFO);
        }
    }

    protected ConfigurationBuilder getBuilder(String resources) throws Exception {
        return new MunitSpringXmlConfigurationBuilder(resources, this.configuration);
    }

    protected void configureMuleContext(MuleContextBuilder contextBuilder) {
        contextBuilder.setWorkListener((WorkListener)new TestingWorkListener());
    }
}

