/*
 * Decompiled with CFR 0.152.
 */
package org.mule.munit.runner.mule.context;

import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.sax.SAXSource;
import org.springframework.beans.factory.xml.DefaultDocumentLoader;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.Attributes2Impl;
import org.xml.sax.helpers.XMLFilterImpl;
import org.xml.sax.helpers.XMLReaderFactory;

public class MunitDocumentLoader
extends DefaultDocumentLoader {
    public Document loadDocument(InputSource inputSource, EntityResolver entityResolver, ErrorHandler errorHandler, int validationMode, boolean namespaceAware) throws Exception {
        XMLReader xmlReader = XMLReaderFactory.createXMLReader();
        LocationFilter locationFilter = new LocationFilter(xmlReader);
        SAXSource saxSource = new SAXSource(locationFilter, inputSource);
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        DOMResult domResult = new DOMResult();
        transformer.transform(saxSource, domResult);
        return (Document)domResult.getNode();
    }

    class LocationFilter
    extends XMLFilterImpl {
        public static final String NAMESPACE = "http://www.mule.org/munit";
        private Locator locator;

        LocationFilter(XMLReader xmlReader) {
            super(xmlReader);
            this.locator = null;
        }

        public void setDocumentLocator(Locator locator) {
            super.setDocumentLocator(locator);
            this.locator = locator;
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            String location = String.valueOf(this.locator.getLineNumber());
            Attributes2Impl attrs = new Attributes2Impl(attributes);
            attrs.addAttribute(NAMESPACE, "__MUNIT_LINE_NUMBER", "__MUNIT_LINE_NUMBER", "CDATA", location);
            super.startElement(uri, localName, qName, attrs);
        }
    }
}

