/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.module.tls.internal.revocation;

import java.net.URI;
import java.net.URISyntaxException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.cert.CertPathBuilder;
import java.security.cert.CertSelector;
import java.security.cert.PKIXBuilderParameters;
import java.security.cert.PKIXRevocationChecker;
import java.security.cert.TrustAnchor;
import java.security.cert.X509CertSelector;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Set;
import javax.net.ssl.CertPathTrustManagerParameters;
import javax.net.ssl.ManagerFactoryParameters;
import org.mule.runtime.api.component.AbstractComponent;
import org.mule.runtime.api.util.Preconditions;
import org.mule.runtime.core.privileged.security.RevocationCheck;

public class CustomOcspResponder
extends AbstractComponent
implements RevocationCheck {
    private String url;
    private String certAlias;

    public void setUrl(String url) {
        this.url = url;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public ManagerFactoryParameters configFor(KeyStore trustStore, Set<TrustAnchor> defaultTrustAnchors) {
        Preconditions.checkArgument((this.url != null ? 1 : 0) != 0, (String)"tls:custom-ocsp-responder requires the 'url' attribute");
        Preconditions.checkArgument((trustStore != null ? 1 : 0) != 0, (String)"tls:custom-ocsp-responder requires a trust store");
        try {
            CertPathBuilder cpb = CertPathBuilder.getInstance("PKIX");
            PKIXRevocationChecker rc = (PKIXRevocationChecker)cpb.getRevocationChecker();
            rc.setOptions(EnumSet.of(PKIXRevocationChecker.Option.NO_FALLBACK));
            if (this.url != null) {
                rc.setOcspResponder(new URI(this.url));
            }
            if (this.certAlias != null) {
                if (trustStore.isCertificateEntry(this.certAlias)) {
                    rc.setOcspResponderCert((X509Certificate)trustStore.getCertificate(this.certAlias));
                } else {
                    throw new IllegalStateException("Key with alias \"" + this.certAlias + "\" was not found");
                }
            }
            PKIXBuilderParameters pkixParams = new PKIXBuilderParameters(trustStore, (CertSelector)new X509CertSelector());
            pkixParams.addCertPathChecker(rc);
            return new CertPathTrustManagerParameters(pkixParams);
        }
        catch (URISyntaxException | GeneralSecurityException e) {
            throw new RuntimeException(e);
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        CustomOcspResponder that = (CustomOcspResponder)((Object)o);
        if (this.url != null ? !this.url.equals(that.url) : that.url != null) {
            return false;
        }
        return this.certAlias != null ? this.certAlias.equals(that.certAlias) : that.certAlias == null;
    }

    public int hashCode() {
        int result = this.url != null ? this.url.hashCode() : 0;
        result = 31 * result + (this.certAlias != null ? this.certAlias.hashCode() : 0);
        return result;
    }
}

