/*
 * Decompiled with CFR 0.152.
 */
package org.mule.maven.client.maven.context.it;

import java.io.File;
import java.util.Optional;
import org.eclipse.aether.artifact.DefaultArtifact;
import org.mule.maven.client.api.MavenClient;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.SettingsSupplierFactory;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.maven.pom.parser.api.model.BundleDependency;
import org.mule.maven.pom.parser.api.model.BundleDescriptor;

public class DependencyResolver
implements AutoCloseable {
    private static final MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)DependencyResolver.class.getClassLoader());
    private final MavenClient mavenClient;

    public DependencyResolver() {
        this(DependencyResolver.getDefaultMavenConfiguration());
    }

    public DependencyResolver(String localRepository) {
        this(DependencyResolver.getDefaultMavenConfiguration(localRepository));
    }

    public DependencyResolver(MavenConfiguration mavenConfig) {
        this.mavenClient = mavenClientProvider.createMavenClient(mavenConfig);
    }

    private static MavenConfiguration getDefaultMavenConfiguration() {
        return DependencyResolver.getDefaultMavenConfiguration(null);
    }

    private static MavenConfiguration getDefaultMavenConfiguration(String localRepository) {
        SettingsSupplierFactory settingsSupplierFactory = mavenClientProvider.getSettingsSupplierFactory();
        Optional globalSettings = settingsSupplierFactory.environmentGlobalSettingsSupplier();
        Optional userSettings = settingsSupplierFactory.environmentUserSettingsSupplier();
        Optional settingsSecurity = settingsSupplierFactory.environmentSettingsSecuritySupplier();
        File localMavenRepository = localRepository != null ? new File(localRepository) : (File)mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier().get();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation(localMavenRepository);
        globalSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).globalSettingsLocation(arg_0));
        userSettings.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).userSettingsLocation(arg_0));
        settingsSecurity.ifPresent(arg_0 -> ((MavenConfiguration.MavenConfigurationBuilder)mavenConfigurationBuilder).settingsSecurityLocation(arg_0));
        return mavenConfigurationBuilder.build();
    }

    public BundleDependency resolveFor(String artifactStr) {
        DefaultArtifact artifact = new DefaultArtifact(artifactStr);
        BundleDescriptor mavenBundleDescriptor = new BundleDescriptor.Builder().setGroupId(artifact.getGroupId()).setArtifactId(artifact.getArtifactId()).setVersion(artifact.getVersion()).setBaseVersion(artifact.getBaseVersion()).setType(artifact.getExtension()).setClassifier(artifact.getClassifier()).build();
        return this.mavenClient.resolveBundleDescriptor(mavenBundleDescriptor);
    }

    @Override
    public void close() throws Exception {
        this.mavenClient.close();
    }
}

