/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.execute;

import java.util.Arrays;
import java.util.HashMap;
import java.util.Properties;
import org.apache.derby.catalog.UUID;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.sql.Activation;
import org.apache.derby.iapi.sql.ResultDescription;
import org.apache.derby.iapi.sql.ResultSet;
import org.apache.derby.iapi.sql.dictionary.ColumnDescriptor;
import org.apache.derby.iapi.sql.dictionary.TableDescriptor;
import org.apache.derby.iapi.sql.execute.ConstantAction;
import org.apache.derby.iapi.sql.execute.ExecRow;
import org.apache.derby.iapi.sql.execute.NoPutResultSet;
import org.apache.derby.iapi.sql.execute.RowChanger;
import org.apache.derby.iapi.types.DataValueDescriptor;
import org.apache.derby.iapi.types.NumberDataValue;
import org.apache.derby.impl.sql.execute.AutoincrementCounter;
import org.apache.derby.impl.sql.execute.DMLWriteResultSet;
import org.apache.derby.impl.sql.execute.InternalTriggerExecutionContext;
import org.apache.derby.impl.sql.execute.TemporaryRowHolderImpl;
import org.apache.derby.impl.sql.execute.ValueRow;

public abstract class DMLWriteGeneratedColumnsResultSet
extends DMLWriteResultSet {
    protected DataValueDescriptor[] aiCache;
    protected String identitySequenceUUIDString;
    protected NoPutResultSet sourceResultSet;
    protected ResultSet autoGeneratedKeysResultSet;
    protected TemporaryRowHolderImpl autoGeneratedKeysRowsHolder;
    protected int[] autoGeneratedKeysColumnIndexes;
    protected boolean autoincrementGenerated;
    protected long identityVal;
    protected boolean setIdentity;

    DMLWriteGeneratedColumnsResultSet(Activation activation) throws StandardException {
        this(activation, activation.getConstantAction());
    }

    DMLWriteGeneratedColumnsResultSet(Activation activation, ConstantAction constantAction) throws StandardException {
        super(activation, constantAction);
    }

    public NumberDataValue getSetAutoincrementValue(int n, long l) throws StandardException {
        return null;
    }

    public void saveAIcacheInformation(String string, String string2, String[] stringArray) throws StandardException {
        if (this.aiCache != null) {
            HashMap<String, Long> hashMap = new HashMap<String, Long>();
            int n = this.aiCache.length;
            for (int i = 0; i < n; ++i) {
                if (this.aiCache[i] == null) continue;
                hashMap.put(AutoincrementCounter.makeIdentity(string, string2, stringArray[i]), this.aiCache[i].getLong());
            }
            InternalTriggerExecutionContext internalTriggerExecutionContext = (InternalTriggerExecutionContext)this.lcc.getTriggerExecutionContext();
            if (internalTriggerExecutionContext == null) {
                this.lcc.copyHashtableToAIHT(hashMap);
            } else {
                internalTriggerExecutionContext.copyHashtableToAIHT(hashMap);
            }
        }
        this.autoGeneratedKeysResultSet = this.activation.getAutoGeneratedKeysResultsetMode() ? this.autoGeneratedKeysRowsHolder.getResultSet() : null;
    }

    protected void verifyAutoGeneratedRScolumnsList(UUID uUID) throws StandardException {
        if (this.activation.getAutoGeneratedKeysResultsetMode()) {
            int[] nArray = this.activation.getAutoGeneratedKeysColumnIndexes();
            if (nArray != null) {
                this.verifyAutoGeneratedColumnsIndexes(nArray, uUID);
            } else {
                String[] stringArray = this.activation.getAutoGeneratedKeysColumnNames();
                if (stringArray != null) {
                    this.verifyAutoGeneratedColumnsNames(stringArray, uUID);
                }
            }
        }
    }

    private void verifyAutoGeneratedColumnsIndexes(int[] nArray, UUID uUID) throws StandardException {
        int n = nArray.length;
        TableDescriptor tableDescriptor = this.lcc.getDataDictionary().getTableDescriptor(uUID);
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(nArray[i]);
            if (this.verifyAutoGenColumn(columnDescriptor)) continue;
            throw StandardException.newException("X0X0E.S", nArray[i], tableDescriptor.getName());
        }
    }

    private void verifyAutoGeneratedColumnsNames(String[] stringArray, UUID uUID) throws StandardException {
        int n = stringArray.length;
        int[] nArray = new int[n];
        TableDescriptor tableDescriptor = this.lcc.getDataDictionary().getTableDescriptor(uUID);
        for (int i = 0; i < n; ++i) {
            if (stringArray[i] == null) {
                throw StandardException.newException("X0X0F.S", stringArray[i], tableDescriptor.getName());
            }
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(stringArray[i]);
            if (!this.verifyAutoGenColumn(columnDescriptor)) {
                throw StandardException.newException("X0X0F.S", stringArray[i], tableDescriptor.getName());
            }
            nArray[i] = columnDescriptor.getPosition();
        }
        this.activation.setAutoGeneratedKeysResultsetInfo(nArray, null);
    }

    private boolean verifyAutoGenColumn(ColumnDescriptor columnDescriptor) {
        return columnDescriptor != null && columnDescriptor.isAutoincrement();
    }

    protected void firstExecuteSpecialHandlingAutoGen(boolean bl, RowChanger rowChanger, UUID uUID) throws StandardException {
        if (bl && this.activation.getAutoGeneratedKeysResultsetMode()) {
            Properties properties = new Properties();
            this.autoGeneratedKeysColumnIndexes = this.activation.getAutoGeneratedKeysColumnIndexes();
            rowChanger.getHeapConglomerateController().getInternalTablePropertySet(properties);
            this.autoGeneratedKeysColumnIndexes = this.autoGeneratedKeysColumnIndexes != null ? this.uniqueColumnPositionArray(this.autoGeneratedKeysColumnIndexes, uUID) : this.generatedColumnPositionsArray(uUID);
            ResultDescription resultDescription = this.lcc.getLanguageFactory().getResultDescription(this.resultDescription, this.autoGeneratedKeysColumnIndexes);
            this.autoGeneratedKeysRowsHolder = new TemporaryRowHolderImpl(this.activation, properties, resultDescription);
        }
    }

    private int[] generatedColumnPositionsArray(UUID uUID) throws StandardException {
        TableDescriptor tableDescriptor = this.lcc.getDataDictionary().getTableDescriptor(uUID);
        int n = tableDescriptor.getMaxColumnID();
        int[] nArray = new int[n];
        Arrays.fill(nArray, -1);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            ColumnDescriptor columnDescriptor = tableDescriptor.getColumnDescriptor(i + 1);
            if (columnDescriptor.isAutoincrement()) {
                ++n2;
                nArray[i] = i + 1;
                continue;
            }
            if (columnDescriptor.getDefaultValue() == null && columnDescriptor.getDefaultInfo() == null) continue;
            ++n2;
            nArray[i] = i + 1;
        }
        int[] nArray2 = new int[n2];
        int n3 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray[i] == -1) continue;
            nArray2[n3++] = nArray[i];
        }
        return nArray2;
    }

    private int[] uniqueColumnPositionArray(int[] nArray, UUID uUID) throws StandardException {
        int n = nArray.length;
        TableDescriptor tableDescriptor = this.lcc.getDataDictionary().getTableDescriptor(uUID);
        int[] nArray2 = new int[tableDescriptor.getMaxColumnID()];
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            if (nArray2[nArray[i] - 1] != 0) continue;
            ++n2;
            nArray2[nArray[i] - 1] = nArray[i];
        }
        int[] nArray3 = new int[n2];
        int n3 = 0;
        for (int i = 0; i < nArray2.length; ++i) {
            if (nArray2[i] == 0) continue;
            nArray3[n3++] = nArray2[i];
        }
        return nArray3;
    }

    protected ExecRow getCompactRow(ExecRow execRow, int[] nArray) throws StandardException {
        int n = execRow.nColumns();
        if (nArray == null) {
            ValueRow valueRow = new ValueRow(n);
            DataValueDescriptor[] dataValueDescriptorArray = execRow.getRowArray();
            DataValueDescriptor[] dataValueDescriptorArray2 = valueRow.getRowArray();
            System.arraycopy(dataValueDescriptorArray, 0, dataValueDescriptorArray2, 0, dataValueDescriptorArray.length);
            return valueRow;
        }
        int n2 = nArray.length;
        ValueRow valueRow = new ValueRow(n2);
        for (int i = 0; i < n2; ++i) {
            valueRow.setColumn(i + 1, execRow.getColumn(nArray[i]));
        }
        return valueRow;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return this.autoGeneratedKeysResultSet;
    }
}

