/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.classloader;

import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.mule.runtime.container.api.ModuleRepository;
import org.mule.runtime.container.api.MuleModule;
import org.mule.runtime.container.internal.ContainerClassLoaderFactory;
import org.mule.runtime.container.internal.DefaultModuleRepository;
import org.mule.runtime.container.internal.JreModuleDiscoverer;
import org.mule.runtime.container.internal.ModuleDiscoverer;
import org.mule.runtime.container.internal.MuleClassLoaderLookupPolicy;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.runtime.module.artifact.api.classloader.ClassLoaderLookupPolicy;
import org.mule.runtime.module.artifact.api.classloader.MuleArtifactClassLoader;
import org.mule.runtime.module.artifact.api.descriptor.ArtifactDescriptor;
import org.mule.test.runner.classloader.TestContainerModuleDiscoverer;

public class TestContainerClassLoaderFactory
extends ContainerClassLoaderFactory
implements AutoCloseable {
    private final Set<String> extraBootPackages;
    private final URL[] urls;
    private final URLClassLoader classLoader;
    private final DefaultModuleRepository testContainerModuleRepository;
    private ArtifactClassLoader containerClassLoader;

    public TestContainerClassLoaderFactory(List<String> extraBootPackages, URL[] urls, ModuleRepository moduleRepository) {
        super(moduleRepository);
        this.extraBootPackages = ImmutableSet.builder().addAll((Iterable)super.getBootPackages()).addAll(extraBootPackages).addAll((Iterable)((MuleModule)new JreModuleDiscoverer().discover().get(0)).getExportedPackages()).build();
        this.urls = urls;
        this.classLoader = new URLClassLoader(urls, null);
        this.testContainerModuleRepository = new DefaultModuleRepository((ModuleDiscoverer)new TestContainerModuleDiscoverer(this.classLoader));
    }

    public ArtifactClassLoader createContainerClassLoader(ClassLoader parentClassLoader) {
        List muleModules = (List)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.testContainerModuleRepository.getModules());
        MuleClassLoaderLookupPolicy lookupPolicy = new MuleClassLoaderLookupPolicy(Collections.emptyMap(), this.getBootPackages());
        return this.createArtifactClassLoader(parentClassLoader, muleModules, (ClassLoaderLookupPolicy)lookupPolicy, new ArtifactDescriptor("mule"));
    }

    protected ArtifactClassLoader createArtifactClassLoader(ClassLoader parentClassLoader, List<MuleModule> muleModules, ClassLoaderLookupPolicy containerLookupPolicy, ArtifactDescriptor artifactDescriptor) {
        ArtifactDescriptor containerDescriptor = new ArtifactDescriptor("mule");
        this.containerClassLoader = new MuleArtifactClassLoader(containerDescriptor.getName(), containerDescriptor, this.urls, parentClassLoader, containerLookupPolicy);
        return this.createContainerFilteringClassLoader((List)ClassUtils.withContextClassLoader((ClassLoader)this.classLoader, () -> this.testContainerModuleRepository.getModules()), this.containerClassLoader);
    }

    public ArtifactClassLoader getContainerClassLoader() {
        return this.containerClassLoader;
    }

    public Set<String> getBootPackages() {
        return this.extraBootPackages;
    }

    public ClassLoaderLookupPolicy getContainerClassLoaderLookupPolicy(ClassLoader classLoader) {
        return super.getContainerClassLoaderLookupPolicy(classLoader, this.testContainerModuleRepository.getModules());
    }

    @Override
    public void close() {
        try {
            this.classLoader.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

