/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.infrastructure;

import com.google.common.collect.ImmutableList;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.jar.Manifest;
import org.mule.runtime.api.dsl.DslResolvingContext;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.core.api.config.MuleManifest;
import org.mule.runtime.core.api.extension.ExtensionManager;
import org.mule.runtime.core.api.extension.MuleExtensionModelProvider;
import org.mule.runtime.core.api.registry.ServiceRegistry;
import org.mule.runtime.core.api.registry.SpiServiceRegistry;
import org.mule.runtime.core.api.util.FileUtils;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.DslResourceFactory;
import org.mule.runtime.extension.api.dsl.syntax.resources.spi.ExtensionSchemaGenerator;
import org.mule.runtime.extension.api.loader.ExtensionModelLoader;
import org.mule.runtime.extension.api.resources.GeneratedResource;
import org.mule.runtime.extension.api.resources.spi.GeneratedResourceFactory;
import org.mule.runtime.internal.dsl.NullDslResolvingContext;
import org.mule.test.runner.infrastructure.ExtensionsTestDslResourcesGenerator;
import org.mule.test.runner.infrastructure.ExtensionsTestLoaderResourcesGenerator;

public class ExtensionsTestInfrastructureDiscoverer {
    private final ServiceRegistry serviceRegistry = new SpiServiceRegistry();
    private final ExtensionManager extensionManager;

    public ExtensionsTestInfrastructureDiscoverer(ExtensionManager extensionManagerAdapter) {
        this.extensionManager = extensionManagerAdapter;
    }

    public ExtensionModel discoverExtension(Class<?> annotatedClass, ExtensionModelLoader loader) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("type", annotatedClass.getName());
        params.put("version", MuleManifest.getProductVersion());
        DslResolvingContext dslResolvingContext = DslResolvingContext.getDefault(Collections.singleton(MuleExtensionModelProvider.getExtensionModel()));
        ExtensionModel model = loader.loadExtensionModel(annotatedClass.getClassLoader(), dslResolvingContext, params);
        this.extensionManager.registerExtension(model);
        return model;
    }

    public List<GeneratedResource> generateLoaderResources(ExtensionModel extensionModel, File generatedResourcesDirectory) {
        this.createManifestFileIfNecessary(generatedResourcesDirectory);
        ExtensionsTestLoaderResourcesGenerator generator = new ExtensionsTestLoaderResourcesGenerator(this.getResourceFactories(), generatedResourcesDirectory);
        generator.generateFor(extensionModel);
        return generator.dumpAll();
    }

    public List<GeneratedResource> generateDslResources(File generatedResourcesDirectory) {
        return this.generateDslResources(generatedResourcesDirectory, null);
    }

    public void generateSchemaTestResource(ExtensionModel model, File generatedResourcesDirectory) {
        String xsdFileName = model.getXmlDslModel().getXsdFileName();
        try {
            ExtensionSchemaGenerator schemaGenerator = this.getSchemaGenerator();
            HashSet<ExtensionModel> models = new HashSet<ExtensionModel>(this.extensionManager.getExtensions());
            models.add(MuleExtensionModelProvider.getExtensionModel());
            String schema = schemaGenerator.generate(model, DslResolvingContext.getDefault(models));
            File xsd = FileUtils.newFile((File)generatedResourcesDirectory, (String)xsdFileName);
            FileUtils.copyStreamToFile((InputStream)new ByteArrayInputStream(schema.getBytes()), (File)xsd);
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("Error generating test xsd resource [%s]: " + e.getMessage(), xsdFileName, e));
        }
    }

    public List<GeneratedResource> generateDslResources(File generatedResourcesDirectory, ExtensionModel forExtensionModel) {
        NullDslResolvingContext context;
        if (this.extensionManager.getExtensions().stream().anyMatch(e -> !e.getImportedTypes().isEmpty())) {
            HashSet<ExtensionModel> models = new HashSet<ExtensionModel>(this.extensionManager.getExtensions());
            models.add(MuleExtensionModelProvider.getExtensionModel());
            context = DslResolvingContext.getDefault(models);
        } else {
            context = new NullDslResolvingContext();
        }
        ExtensionsTestDslResourcesGenerator dslResourceGenerator = new ExtensionsTestDslResourcesGenerator(this.getDslResourceFactories(), generatedResourcesDirectory, (DslResolvingContext)context);
        this.extensionManager.getExtensions().stream().filter(runtimeExtensionModel -> forExtensionModel != null ? runtimeExtensionModel.equals(forExtensionModel) : true).forEach(dslResourceGenerator::generateFor);
        return dslResourceGenerator.dumpAll();
    }

    private List<GeneratedResourceFactory> getResourceFactories() {
        return ImmutableList.copyOf((Collection)this.serviceRegistry.lookupProviders(GeneratedResourceFactory.class, Thread.currentThread().getContextClassLoader()));
    }

    private ExtensionSchemaGenerator getSchemaGenerator() {
        return (ExtensionSchemaGenerator)ImmutableList.copyOf((Collection)this.serviceRegistry.lookupProviders(ExtensionSchemaGenerator.class, Thread.currentThread().getContextClassLoader())).get(0);
    }

    private List<DslResourceFactory> getDslResourceFactories() {
        return ImmutableList.copyOf((Collection)this.serviceRegistry.lookupProviders(DslResourceFactory.class, Thread.currentThread().getContextClassLoader()));
    }

    private File createManifestFileIfNecessary(File targetDirectory) {
        return this.createManifestFileIfNecessary(targetDirectory, MuleManifest.getManifest());
    }

    private File createManifestFileIfNecessary(File targetDirectory, Manifest sourceManifest) {
        try {
            File manifestFile = new File(targetDirectory.getPath(), "MANIFEST.MF");
            if (!manifestFile.exists()) {
                Manifest manifest = new Manifest(sourceManifest);
                try (FileOutputStream fileOutputStream = new FileOutputStream(manifestFile);){
                    manifest.write(fileOutputStream);
                }
            }
            return manifestFile;
        }
        catch (IOException e) {
            throw new RuntimeException("Error creating discoverer", e);
        }
    }
}

