/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner.api;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathUrlProvider {
    protected final transient Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<URL> urls;

    public ClassPathUrlProvider() {
        this(new ArrayList<URL>());
    }

    public ClassPathUrlProvider(List<URL> urls) {
        Objects.requireNonNull(urls, "urls cannot be null");
        this.urls = this.readUrlsFromSystemProperties();
        this.urls.addAll(urls);
    }

    private List<URL> readUrlsFromSystemProperties() {
        LinkedHashSet<URL> urls = new LinkedHashSet<URL>();
        this.addUrlsFromSystemProperty(urls, "jdk.module.path");
        this.addUrlsFromSystemProperty(urls, "java.class.path");
        this.addUrlsFromSystemProperty(urls, "sun.boot.class.path");
        this.addUrlsFromSystemProperty(urls, "surefire.test.class.path");
        if (this.logger.isDebugEnabled()) {
            StringBuilder builder = new StringBuilder("ClassPath:");
            urls.stream().forEach(url -> builder.append(File.pathSeparator).append(url));
            this.logger.debug(builder.toString());
        }
        return Lists.newArrayList(urls);
    }

    public List<URL> getURLs() {
        return this.urls;
    }

    protected void addUrlsFromSystemProperty(Collection<URL> urls, String propertyName) {
        String property = System.getProperty(propertyName);
        if (property != null) {
            for (String file : property.split(File.pathSeparator)) {
                try {
                    urls.add(new File(file).toURI().toURL());
                }
                catch (MalformedURLException e) {
                    throw new IllegalArgumentException("Cannot create a URL from file path: " + file, e);
                }
            }
        }
    }
}

