/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.runner;

import com.google.common.base.Throwables;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.io.File;
import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.Supplier;
import org.junit.internal.builders.AnnotatedBuilder;
import org.junit.runner.Description;
import org.junit.runner.Runner;
import org.junit.runner.manipulation.Filter;
import org.junit.runner.manipulation.Filterable;
import org.junit.runner.manipulation.NoTestsRemainException;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.RunnerBuilder;
import org.junit.runners.model.TestClass;
import org.mule.maven.client.api.MavenClientProvider;
import org.mule.maven.client.api.model.MavenConfiguration;
import org.mule.runtime.api.exception.MuleRuntimeException;
import org.mule.runtime.api.i18n.I18nMessageFactory;
import org.mule.runtime.core.api.util.ClassUtils;
import org.mule.runtime.module.artifact.api.classloader.ArtifactClassLoader;
import org.mule.test.runner.ApplicationClassLoaderAware;
import org.mule.test.runner.ContainerClassLoaderAware;
import org.mule.test.runner.PluginClassLoadersAware;
import org.mule.test.runner.RunnerConfiguration;
import org.mule.test.runner.RunnerDelegateTo;
import org.mule.test.runner.ServiceClassLoadersAware;
import org.mule.test.runner.api.AetherClassPathClassifier;
import org.mule.test.runner.api.ArtifactClassLoaderHolder;
import org.mule.test.runner.api.ArtifactClassificationTypeResolver;
import org.mule.test.runner.api.ArtifactIsolatedClassLoaderBuilder;
import org.mule.test.runner.api.ClassPathUrlProvider;
import org.mule.test.runner.api.DependencyResolver;
import org.mule.test.runner.classification.DefaultWorkspaceReader;
import org.mule.test.runner.maven.AutoDiscoverWorkspaceLocationResolver;
import org.mule.test.runner.utils.AnnotationUtils;
import org.mule.test.runner.utils.RunnerModuleUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactClassLoaderRunner
extends Runner
implements Filterable {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactClassLoaderRunner.class);
    private static ArtifactClassLoaderHolder artifactClassLoaderHolder;
    private static RunnerConfiguration runnerConfiguration;
    private static Exception errorCreatingClassLoaderTestRunner;
    private static boolean staticFieldsInjected;
    private static Throwable errorWhileSettingClassLoaders;
    private final Runner delegate;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArtifactClassLoaderRunner(Class<?> clazz, RunnerBuilder builder) throws Throwable {
        if (errorCreatingClassLoaderTestRunner != null) {
            throw errorCreatingClassLoaderTestRunner;
        }
        Map<String, String> originalSystemPropertiesValues = Collections.emptyMap();
        try {
            if (artifactClassLoaderHolder == null) {
                try {
                    runnerConfiguration = RunnerConfiguration.readConfiguration(clazz);
                    originalSystemPropertiesValues = ArtifactClassLoaderRunner.configureSystemPropertyValues();
                    artifactClassLoaderHolder = ArtifactClassLoaderRunner.createClassLoaderTestRunner(clazz, runnerConfiguration);
                }
                catch (Exception e) {
                    errorCreatingClassLoaderTestRunner = e;
                    throw e;
                }
            } else {
                this.checkConfiguration(clazz);
            }
            Class<?> isolatedTestClass = this.getTestClass(clazz);
            ClassLoader testRunnerClassLoader = artifactClassLoaderHolder.getTestRunnerPluginClassLoader().getClassLoader();
            ClassLoader contextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader(testRunnerClassLoader);
                Class<?> runnerDelegateToClass = artifactClassLoaderHolder.loadClassWithATestRunnerClassLoader(RunnerDelegateTo.class.getName());
                this.delegate = new AnnotatedBuilder(builder).buildRunner((Class)AnnotationUtils.getAnnotationAttributeFrom(isolatedTestClass, runnerDelegateToClass, "value"), isolatedTestClass);
            }
            finally {
                Thread.currentThread().setContextClassLoader(contextClassLoader);
            }
            if (staticFieldsInjected && errorWhileSettingClassLoaders != null) {
                throw Throwables.propagate((Throwable)errorWhileSettingClassLoaders);
            }
            ClassUtils.withContextClassLoader((ClassLoader)testRunnerClassLoader, () -> {
                try {
                    if (!staticFieldsInjected) {
                        ArtifactClassLoaderRunner.injectPluginsClassLoaders(artifactClassLoaderHolder, isolatedTestClass);
                        ArtifactClassLoaderRunner.injectServicesClassLoaders(artifactClassLoaderHolder, isolatedTestClass);
                        ArtifactClassLoaderRunner.injectContainerClassLoader(artifactClassLoaderHolder, isolatedTestClass);
                        ArtifactClassLoaderRunner.injectApplicationClassLoader(artifactClassLoaderHolder, isolatedTestClass);
                    }
                }
                catch (Throwable t) {
                    errorWhileSettingClassLoaders = t;
                    throw Throwables.propagate((Throwable)t);
                }
                finally {
                    staticFieldsInjected = true;
                }
            });
        }
        finally {
            ArtifactClassLoaderRunner.restoreSystemPropertyValues(originalSystemPropertiesValues);
        }
    }

    private static Map<String, String> configureSystemPropertyValues() {
        HashMap<String, String> originalSystemPropertyValues = new HashMap<String, String>();
        runnerConfiguration.getSystemProperties().entrySet().forEach(sp -> {
            originalSystemPropertyValues.put((String)sp.getKey(), System.getProperty((String)sp.getKey()));
            System.setProperty((String)sp.getKey(), (String)sp.getValue());
        });
        return originalSystemPropertyValues;
    }

    private static void restoreSystemPropertyValues(Map<String, String> originalSystemPropertiesValues) {
        originalSystemPropertiesValues.entrySet().forEach(sp -> {
            if (sp.getValue() != null) {
                System.setProperty((String)sp.getKey(), (String)sp.getValue());
            } else {
                System.clearProperty((String)sp.getKey());
            }
        });
    }

    private void checkConfiguration(Class<?> klass) {
        RunnerConfiguration testRunnerConfiguration = RunnerConfiguration.readConfiguration(klass);
        if (!runnerConfiguration.equals(testRunnerConfiguration)) {
            throw new IllegalArgumentException("Invalid configuration defined for test: " + klass + " . Is not supported to have multiple configurations of the runner because class loaders are created only once for all the tests in the module. Current configuration loaded was: " + runnerConfiguration + " but configuration obtained from test class was: " + testRunnerConfiguration);
        }
    }

    private static synchronized ArtifactClassLoaderHolder createClassLoaderTestRunner(Class<?> klass, RunnerConfiguration runnerConfiguration) {
        ArtifactClassLoaderHolder artifactClassLoaderHolder;
        Properties excludedProperties;
        File targetTestClassesFolder = new File(klass.getProtectionDomain().getCodeSource().getLocation().getPath());
        ArtifactIsolatedClassLoaderBuilder builder = new ArtifactIsolatedClassLoaderBuilder();
        File rootArtifactClassesFolder = new File(targetTestClassesFolder.getParentFile(), "classes");
        builder.setRootArtifactClassesFolder(rootArtifactClassesFolder);
        builder.setPluginResourcesFolder(targetTestClassesFolder.getParentFile());
        builder.setProvidedExclusions(runnerConfiguration.getProvidedExclusions());
        builder.setTestExclusions(runnerConfiguration.getTestExclusions());
        builder.setTestInclusions(runnerConfiguration.getTestInclusions());
        builder.setExportPluginClasses(runnerConfiguration.getExportPluginClasses());
        builder.setApplicationSharedLibCoordinates(runnerConfiguration.getSharedApplicationRuntimeLibs());
        builder.setApplicationLibCoordinates(runnerConfiguration.getApplicationRuntimeLibs());
        builder.setTestRunnerExportedLibCoordinates(runnerConfiguration.getTestRunnerExportedRuntimeLibs());
        builder.setExtensionMetadataGeneration(true);
        try {
            excludedProperties = RunnerModuleUtils.getExcludedProperties();
        }
        catch (IOException e) {
            throw new RuntimeException("Error while reading excluded properties", e);
        }
        Set<String> excludedArtifactsList = ArtifactClassLoaderRunner.getExcludedArtifacts(excludedProperties);
        builder.setExcludedArtifacts(excludedArtifactsList);
        builder.setExtraBootPackages(ArtifactClassLoaderRunner.getExtraBootPackages(excludedProperties));
        builder.setExtraPrivilegedArtifacts(runnerConfiguration.getExtraPrivilegedArtifacts());
        ClassPathUrlProvider classPathUrlProvider = new ClassPathUrlProvider();
        List<URL> classPath = classPathUrlProvider.getURLs();
        builder.setClassPathUrlProvider(classPathUrlProvider);
        AutoDiscoverWorkspaceLocationResolver workspaceLocationResolver = new AutoDiscoverWorkspaceLocationResolver(classPath, rootArtifactClassesFolder);
        MavenClientProvider mavenClientProvider = MavenClientProvider.discoverProvider((ClassLoader)ArtifactClassLoaderRunner.class.getClassLoader());
        Supplier localMavenRepository = mavenClientProvider.getLocalRepositorySuppliers().environmentMavenRepositorySupplier();
        MavenConfiguration.MavenConfigurationBuilder mavenConfigurationBuilder = MavenConfiguration.newMavenConfigurationBuilder().forcePolicyUpdateNever(true).localMavenRepositoryLocation((File)localMavenRepository.get());
        mavenClientProvider.getSettingsSupplierFactory().addToMavenConfig(mavenConfigurationBuilder);
        MavenConfiguration mavenConfiguration = mavenConfigurationBuilder.build();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Using MavenConfiguration: {}", (Object)mavenConfiguration);
        }
        DependencyResolver dependencyResolver = new DependencyResolver(mavenConfiguration, Optional.of(new DefaultWorkspaceReader(classPath, workspaceLocationResolver)));
        AetherClassPathClassifier classPathClassifier = new AetherClassPathClassifier(dependencyResolver, new ArtifactClassificationTypeResolver(dependencyResolver));
        try {
            builder.setClassPathClassifier(classPathClassifier);
            artifactClassLoaderHolder = builder.build();
        }
        catch (Throwable throwable) {
            try {
                try {
                    classPathClassifier.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new MuleRuntimeException(I18nMessageFactory.createStaticMessage((String)"Error while building the 'ArtifactClassLoaderHolder'"), (Throwable)e);
            }
        }
        classPathClassifier.close();
        return artifactClassLoaderHolder;
    }

    private static Set<String> getExcludedArtifacts(Properties excludedProperties) {
        String excludedArtifacts = excludedProperties.getProperty("excluded.artifacts");
        HashSet<String> excludedArtifactsList = new HashSet<String>();
        if (excludedArtifacts != null) {
            for (String exclusion : excludedArtifacts.split(",")) {
                excludedArtifactsList.add(exclusion);
            }
        }
        return excludedArtifactsList;
    }

    private static List<String> getExtraBootPackages(Properties excludedProperties) {
        HashSet packages = Sets.newHashSet();
        String excludedExtraBootPackages = excludedProperties.getProperty("extraBoot.packages");
        if (excludedExtraBootPackages != null) {
            for (String extraBootPackage : excludedExtraBootPackages.split(",")) {
                packages.add(extraBootPackage);
            }
        } else {
            LOGGER.warn("excluded.properties found but there is no list of extra boot packages defined to be added to container, this could be the reason why the test may fail later due to JUnit classes are not found");
        }
        return Lists.newArrayList((Iterable)packages);
    }

    private static void injectPluginsClassLoaders(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass) throws Throwable {
        Class<PluginClassLoadersAware> pluginClassLoadersAwareClass = PluginClassLoadersAware.class;
        String expectedParamType = "List<" + ArtifactClassLoader.class + ">";
        FrameworkMethod method = ArtifactClassLoaderRunner.getAnnotatedMethod(artifactClassLoaderHolder, isolatedTestClass, pluginClassLoadersAwareClass, expectedParamType);
        List<ArtifactClassLoader> valueToInject = artifactClassLoaderHolder.getPluginsClassLoaders();
        ArtifactClassLoaderRunner.doFieldInjection(pluginClassLoadersAwareClass, method, valueToInject, expectedParamType);
    }

    private static void injectServicesClassLoaders(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass) throws Throwable {
        Class<ServiceClassLoadersAware> serviceClassLoadersAwareClass = ServiceClassLoadersAware.class;
        String expectedParamType = "List<" + ArtifactClassLoader.class + ">";
        FrameworkMethod method = ArtifactClassLoaderRunner.getAnnotatedMethod(artifactClassLoaderHolder, isolatedTestClass, serviceClassLoadersAwareClass, expectedParamType);
        List<ArtifactClassLoader> valueToInject = artifactClassLoaderHolder.getServicesClassLoaders();
        ArtifactClassLoaderRunner.doFieldInjection(serviceClassLoadersAwareClass, method, valueToInject, expectedParamType);
    }

    private static void injectContainerClassLoader(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass) throws Throwable {
        Class<ContainerClassLoaderAware> containerClassLoaderAwareClass = ContainerClassLoaderAware.class;
        String expectedParamType = ArtifactClassLoader.class.getName();
        FrameworkMethod method = ArtifactClassLoaderRunner.getAnnotatedMethod(artifactClassLoaderHolder, isolatedTestClass, containerClassLoaderAwareClass, expectedParamType);
        ArtifactClassLoader containerClassLoader = artifactClassLoaderHolder.getContainerClassLoader();
        Field artifactClassLoaderField = containerClassLoader.getClass().getSuperclass().getDeclaredField("artifactClassLoader");
        artifactClassLoaderField.setAccessible(true);
        Object valueToInject = artifactClassLoaderField.get(containerClassLoader);
        ArtifactClassLoaderRunner.doFieldInjection(containerClassLoaderAwareClass, method, valueToInject, expectedParamType);
    }

    private static void injectApplicationClassLoader(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass) throws Throwable {
        Class<ApplicationClassLoaderAware> applicationClassLoaderAwareClass = ApplicationClassLoaderAware.class;
        String expectedParamType = ArtifactClassLoader.class.getName();
        FrameworkMethod method = ArtifactClassLoaderRunner.getAnnotatedMethod(artifactClassLoaderHolder, isolatedTestClass, applicationClassLoaderAwareClass, expectedParamType);
        ArtifactClassLoader applicationClassLoader = artifactClassLoaderHolder.getApplicationClassLoader();
        ArtifactClassLoaderRunner.doFieldInjection(applicationClassLoaderAwareClass, method, applicationClassLoader, expectedParamType);
    }

    private static void doFieldInjection(Class<? extends Annotation> containerClassLoaderAwareClass, FrameworkMethod method, Object value, String expectedParamType) throws Throwable {
        method.getMethod().setAccessible(true);
        try {
            method.invokeExplosively(null, new Object[]{value});
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Method marked with annotation " + containerClassLoaderAwareClass.getName() + " should receive a parameter of type " + expectedParamType);
        }
        finally {
            method.getMethod().setAccessible(false);
        }
    }

    private static FrameworkMethod getAnnotatedMethod(ArtifactClassLoaderHolder artifactClassLoaderHolder, Class<?> isolatedTestClass, Class<? extends Annotation> annotationClass, String expectedParamType) throws ClassNotFoundException {
        TestClass testClass = new TestClass(isolatedTestClass);
        Class<?> artifactContextAwareAnn = artifactClassLoaderHolder.loadClassWithATestRunnerClassLoader(annotationClass.getName());
        List contextAwareMethods = testClass.getAnnotatedMethods(artifactContextAwareAnn);
        if (contextAwareMethods.size() != 1) {
            throw new IllegalStateException("Isolation tests need to have one method marked with annotation " + annotationClass.getName());
        }
        FrameworkMethod method = (FrameworkMethod)contextAwareMethods.get(0);
        if (!method.isStatic() || method.isPublic()) {
            throw new IllegalStateException("Method marked with annotation " + annotationClass.getName() + " should be private static and receive a parameter of type " + expectedParamType);
        }
        return method;
    }

    private Class<?> getTestClass(Class<?> clazz) throws InitializationError {
        try {
            return artifactClassLoaderHolder.loadClassWithATestRunnerClassLoader(clazz.getName());
        }
        catch (Exception e) {
            throw new InitializationError((Throwable)e);
        }
    }

    public Description getDescription() {
        return this.delegate.getDescription();
    }

    public void run(RunNotifier notifier) {
        ClassUtils.withContextClassLoader((ClassLoader)artifactClassLoaderHolder.getTestRunnerPluginClassLoader().getClassLoader(), () -> this.delegate.run(notifier));
    }

    public void filter(Filter filter) throws NoTestsRemainException {
        if (this.delegate instanceof Filterable) {
            ((Filterable)this.delegate).filter(filter);
        }
    }

    static {
        staticFieldsInjected = false;
    }
}

