/*
 * Decompiled with CFR 0.152.
 */
package org.mule.test.transactional.connection;

import javax.transaction.xa.XAResource;
import org.mule.runtime.api.tx.TransactionException;
import org.mule.sdk.api.connectivity.XATransactionalConnection;
import org.mule.test.transactional.connection.DummyXaResource;
import org.mule.test.transactional.connection.SdkTestTransactionalConnection;
import org.mule.test.transactional.connection.TestXaTransactionalConnection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SdkTestXaTransactionalConnection
implements SdkTestTransactionalConnection,
XATransactionalConnection {
    private static final Logger logger = LoggerFactory.getLogger(TestXaTransactionalConnection.class);
    private DummyXaResource xaResource;
    private double connectionId;

    SdkTestXaTransactionalConnection(DummyXaResource xaResource) {
        this.xaResource = xaResource;
        this.connectionId = Math.random();
    }

    public void begin() throws TransactionException {
        logger.debug("Begin Conn Transaction");
    }

    public void commit() throws TransactionException {
        logger.debug("Commit Conn Transaction");
    }

    public void rollback() throws TransactionException {
        logger.debug("Rollback Conn Transaction");
    }

    public XAResource getXAResource() {
        logger.debug("Giving XA Resource");
        return this.xaResource;
    }

    public void close() {
        logger.debug("Closing XA Transaction");
    }

    @Override
    public double getConnectionId() {
        return this.connectionId;
    }

    @Override
    public boolean isTransactionBegun() {
        return this.xaResource.isTxStarted();
    }

    @Override
    public boolean isTransactionCommited() {
        return this.xaResource.isCommitStarted();
    }

    @Override
    public boolean isTransactionRolledback() {
        return this.xaResource.isRollbackExecuted();
    }

    @Override
    public void disconnect() {
    }

    @Override
    public boolean isConnected() {
        return false;
    }
}

