/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.maven.plugin.logging.Log;
import org.jdom2.Document;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaders;
import org.mule.tools.apikit.input.parsers.APIKitConfigParser;
import org.mule.tools.apikit.input.parsers.APIKitFlowsParser;
import org.mule.tools.apikit.input.parsers.APIKitRoutersParser;
import org.mule.tools.apikit.input.parsers.HttpListenerConfigParser;
import org.mule.tools.apikit.model.API;
import org.mule.tools.apikit.model.APIFactory;
import org.mule.tools.apikit.model.APIKitConfig;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.model.ResourceActionMimeTypeTriplet;

public class MuleConfigParser {
    private Set<ResourceActionMimeTypeTriplet> entries = new HashSet<ResourceActionMimeTypeTriplet>();
    private Map<String, API> includedApis = new HashMap<String, API>();
    private Map<String, HttpListenerConfig> httpListenerConfigs = new HashMap<String, HttpListenerConfig>();
    private Map<String, APIKitConfig> apikitConfigs = new HashMap<String, APIKitConfig>();
    private final APIFactory apiFactory;
    private final Log log;

    public MuleConfigParser(Log log, APIFactory apiFactory) {
        this.apiFactory = apiFactory;
        this.httpListenerConfigs.putAll(apiFactory.getDomainHttpListenerConfigs());
        this.log = log;
    }

    public MuleConfigParser parse(Set<File> ramlPaths, Map<File, InputStream> streams) {
        for (Map.Entry<File, InputStream> fileStreamEntry : streams.entrySet()) {
            InputStream stream = fileStreamEntry.getValue();
            File file = fileStreamEntry.getKey();
            try {
                this.parseMuleConfigFile(file, stream, ramlPaths);
                stream.close();
            }
            catch (Exception e) {
                this.log.error((CharSequence)("Error parsing Mule xml config file: [" + file + "]. Reason: " + e.getMessage()));
                this.log.debug((Throwable)e);
            }
        }
        return this;
    }

    protected void parseMuleConfigFile(File file, InputStream stream, Set<File> ramlPaths) throws JDOMException, IOException {
        SAXBuilder saxBuilder = new SAXBuilder((XMLReaderJDOMFactory)XMLReaders.NONVALIDATING);
        Document document = saxBuilder.build(stream);
        this.apikitConfigs.putAll((Map<String, APIKitConfig>)new APIKitConfigParser().parse(document));
        this.httpListenerConfigs.putAll((Map<String, HttpListenerConfig>)new HttpListenerConfigParser().parse(document));
        this.includedApis.putAll((Map<String, API>)new APIKitRoutersParser(this.apikitConfigs, this.httpListenerConfigs, ramlPaths, file, this.apiFactory).parse(document));
        this.entries.addAll((Collection<ResourceActionMimeTypeTriplet>)new APIKitFlowsParser(this.includedApis).parse(document));
    }

    public Map<String, APIKitConfig> getApikitConfigs() {
        return this.apikitConfigs;
    }

    public Set<ResourceActionMimeTypeTriplet> getEntries() {
        return this.entries;
    }

    public Set<API> getIncludedApis() {
        HashSet<API> apis = new HashSet<API>();
        apis.addAll(this.includedApis.values());
        return apis;
    }
}

