/*
 * Decompiled with CFR 0.152.
 */
package org.mule.tools.apikit.input.parsers;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.Namespace;
import org.jdom2.filter.Filters;
import org.jdom2.xpath.XPathExpression;
import org.jdom2.xpath.XPathFactory;
import org.mule.tools.apikit.input.parsers.MuleConfigFileParser;
import org.mule.tools.apikit.model.HttpListenerConfig;
import org.mule.tools.apikit.output.MuleConfigGenerator;

public class HttpListenerConfigParser
implements MuleConfigFileParser {
    @Override
    public Map<String, HttpListenerConfig> parse(Document document) {
        HashMap<String, HttpListenerConfig> httpListenerConfigMap = new HashMap<String, HttpListenerConfig>();
        XPathExpression xp = XPathFactory.instance().compile("//*/*[local-name()='listener-config']", Filters.element((Namespace)MuleConfigGenerator.HTTP_NAMESPACE.getNamespace()));
        List elements = xp.evaluate((Object)document);
        for (Element element : elements) {
            String basePath;
            String name = element.getAttributeValue("name");
            if (name == null) {
                throw new IllegalStateException("Cannot retrieve name.");
            }
            String host = element.getAttributeValue("host");
            if (host == null) {
                throw new IllegalStateException("Cannot retrieve host.");
            }
            String port = element.getAttributeValue("port");
            if (port == null) {
                port = Integer.toString(8081);
            }
            if ((basePath = element.getAttributeValue("basePath")) == null) {
                basePath = "/";
            } else if (!basePath.startsWith("/")) {
                basePath = "/" + basePath;
            }
            httpListenerConfigMap.put(name, new HttpListenerConfig(name, host, port, basePath));
        }
        return httpListenerConfigMap;
    }
}

