/*
 * Decompiled with CFR 0.152.
 */
package com.eaio.util;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Resource {
    private static final Logger LOG = LoggerFactory.getLogger(Resource.class);
    private static Map<String, String> insteadOfClose = new ConcurrentHashMap<String, String>(13);
    private static Map<String, String> beforeClose = new ConcurrentHashMap<String, String>(5);
    private static Map<String, String> afterClose = new ConcurrentHashMap<String, String>(5);

    static {
        Resource.beforeClose("javax.jms.Connection", "stop");
        Resource.beforeClose("javax.imageio.ImageWriter", "reset");
        Resource.beforeClose("javax.imageio.stream.ImageInputStream", "flush");
        Resource.insteadOfClose("com.eaio.nativecall.NativeCall", "destroy");
        Resource.insteadOfClose("com.jcraft.jsch.Channel", "disconnect");
        Resource.insteadOfClose("de.intarsys.cwt.environment.IGraphicsContext", "dispose");
        Resource.insteadOfClose("groovyx.net.http.HTTPBuilder", "shutdown");
        Resource.insteadOfClose("java.lang.Process", "destroy");
        Resource.insteadOfClose("javax.imageio.ImageReader", "dispose");
        Resource.insteadOfClose("javax.imageio.ImageWriter", "dispose");
        Resource.insteadOfClose("org.apache.http.impl.client.AbstractHttpClient", "shutdown");
        Resource.insteadOfClose("org.infinispan.Cache", "stop");
        Resource.insteadOfClose("org.infinispan.manager.DefaultCacheManager", "stop");
    }

    private Resource() {
    }

    public static void beforeClose(Class<?> clazz, String method) {
        Resource.beforeClose(clazz.getName(), method);
    }

    public static void beforeClose(String className, String method) {
        beforeClose.put(className, method);
    }

    public static void afterClose(Class<?> clazz, String method) {
        Resource.afterClose(clazz.getName(), method);
    }

    public static void afterClose(String className, String method) {
        afterClose.put(className, method);
    }

    public static void insteadOfClose(Class<?> clazz, String method) {
        Resource.insteadOfClose(clazz.getName(), method);
    }

    public static void insteadOfClose(String className, String method) {
        insteadOfClose.put(className, method);
    }

    public static void close(Object ... objects) {
        if (objects == null) {
            return;
        }
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object != null) {
                Resource.callFromMap(beforeClose, object);
                if (!Resource.callFromMap(insteadOfClose, object)) {
                    Resource.callVoidMethod(object, "close");
                }
                Resource.callFromMap(afterClose, object);
            }
            ++n2;
        }
    }

    private static boolean callFromMap(Map<String, String> map, Object object) {
        return Resource.callFromMap(map, object, object.getClass());
    }

    private static boolean callFromMap(Map<String, String> map, Object object, Class<?> currClass) {
        String voidMethod;
        String currentClassName = currClass.getName();
        String string = voidMethod = map == null ? null : map.get(currentClassName);
        if (voidMethod != null) {
            Resource.callVoidMethod(object, voidMethod);
            return true;
        }
        if (Resource.callFromMapFromInterfaces(map, object, currClass)) {
            return true;
        }
        return Resource.hasSuperclass(currClass) && Resource.callFromMap(map, object, currClass.getSuperclass());
    }

    private static boolean callFromMapFromInterfaces(Map<String, String> map, Object object, Class<?> currClass) {
        boolean atLeastOneMethodCalled = false;
        Class<?>[] classArray = currClass.getInterfaces();
        int n = classArray.length;
        int n2 = 0;
        while (n2 < n) {
            Class<?> currentInterface = classArray[n2];
            if (Resource.callFromMap(map, object, currentInterface)) {
                atLeastOneMethodCalled = true;
            }
            ++n2;
        }
        return atLeastOneMethodCalled;
    }

    private static boolean hasSuperclass(Class<?> clazz) {
        return clazz != null && clazz != Object.class && clazz.getSuperclass() != null;
    }

    private static void callVoidMethod(Object object, String method) {
        try {
            Method m4 = object.getClass().getMethod(method, new Class[0]);
            m4.invoke(object, new Object[0]);
        }
        catch (NoSuchMethodException ex) {
            Resource.log(object, ex);
        }
        catch (IllegalArgumentException ex) {
            Resource.log(object, ex);
        }
        catch (IllegalAccessException ex) {
            Resource.log(object, ex);
        }
        catch (InvocationTargetException ex) {
            Resource.log(object, ex.getCause());
        }
        catch (SecurityException ex) {
            Resource.log(object, ex);
        }
    }

    private static void log(Object object, Throwable throwable) {
        if (LOG.isTraceEnabled()) {
            LOG.warn(object.getClass().getName(), throwable);
        } else if (LOG.isDebugEnabled()) {
            LOG.warn(String.valueOf(object.getClass().getName()) + ": " + throwable.getClass().getName() + ": " + throwable.getLocalizedMessage());
        }
    }
}

