/*
 * Decompiled with CFR 0.152.
 */
package com.github.pjfanning.poi.xssf.streaming;

import com.github.pjfanning.poi.xssf.streaming.SharedStringsTableBase;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.poi.openxml4j.opc.OPCPackage;
import org.apache.poi.openxml4j.opc.PackagePart;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.xssf.usermodel.XSSFRelation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapBackedSharedStringsTable
extends SharedStringsTableBase {
    private static final Logger log = LoggerFactory.getLogger(MapBackedSharedStringsTable.class);

    public MapBackedSharedStringsTable() throws IOException {
        this(false);
    }

    public MapBackedSharedStringsTable(boolean fullFormat) {
        super(fullFormat);
        this.strings = new ConcurrentHashMap();
        this.stmap = new ConcurrentHashMap();
    }

    public MapBackedSharedStringsTable(OPCPackage pkg) throws IOException {
        this(pkg, false);
    }

    public MapBackedSharedStringsTable(OPCPackage pkg, boolean fullFormat) throws IOException {
        this(fullFormat);
        ArrayList<PackagePart> parts = pkg.getPartsByContentType(XSSFRelation.SHARED_STRINGS.getContentType());
        if (!parts.isEmpty()) {
            PackagePart sstPart = parts.get(0);
            this.readFrom(sstPart.getInputStream());
        }
    }

    @Override
    protected Logger getLogger() {
        return log;
    }

    @Override
    protected Iterator<Integer> keyIterator() {
        return this.strings.keySet().iterator();
    }

    @Override
    public List<RichTextString> getSharedStringItems() {
        throw new UnsupportedOperationException("MapBackedSharedStringsTable only supports streaming access of shared strings");
    }

    @Override
    public void close() throws IOException {
        this.strings.clear();
        this.stmap.clear();
    }
}

