/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats;

import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.TypeFormatBase;
import java.io.IOException;

public abstract class StringFormatBase
extends TypeFormatBase {
    protected final TypeFormatConstants.FillMode spaceFill;

    public StringFormatBase(String code, int min2, int max, TypeFormatConstants.FillMode mode, char fill) {
        super(code, min2, max, fill);
        this.spaceFill = mode;
        if (this.spaceFill.numberOnly()) {
            throw new IllegalArgumentException("Numeric fill option not supported");
        }
    }

    public abstract Object parseToken(LexerBase var1) throws LexicalException;

    public abstract String buildToken(Object var1, WriterBase var2) throws LexicalException;

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        this.checkInputLength(lexer);
        switch (this.spaceFill) {
            case LEFT: {
                StringFormatBase.stripSpaceRight(this.fillChar, lexer.tokenBuilder());
                break;
            }
            case RIGHT: {
                StringFormatBase.stripSpaceLeft(this.fillChar, lexer.tokenBuilder());
                break;
            }
            case NONE: {
                break;
            }
            default: {
                throw new IllegalStateException("Invalid string format fill setting");
            }
        }
        return this.parseToken(lexer);
    }

    @Override
    public void write(Object value, WriterBase writer) throws IOException {
        String text = this.buildToken(value, writer);
        writer.startToken();
        switch (this.spaceFill) {
            case LEFT: {
                text = this.checkOutputMaxLength(text, writer);
                writer.writeEscaped(text);
                StringFormatBase.writePadding(this.minLength - text.length(), this.fillChar, writer);
                break;
            }
            case RIGHT: {
                text = this.checkOutputMaxLength(text, writer);
                StringFormatBase.writePadding(this.minLength - text.length(), this.fillChar, writer);
                writer.writeEscaped(text);
                break;
            }
            case NONE: {
                text = this.checkOutputLength(text, writer);
                writer.writeEscaped(text);
                break;
            }
            default: {
                throw new IllegalStateException("Invalid string format fill setting");
            }
        }
    }

    @Override
    public boolean equals(Object obj) {
        return obj instanceof StringFormatBase && this.spaceFill == ((StringFormatBase)obj).spaceFill && super.equals(obj);
    }
}

