/*
 * Decompiled with CFR 0.152.
 */
package com.mulesoft.flatfile.lexical.formats.old;

import com.mulesoft.flatfile.lexical.ErrorHandler;
import com.mulesoft.flatfile.lexical.LexerBase;
import com.mulesoft.flatfile.lexical.LexicalException;
import com.mulesoft.flatfile.lexical.TypeFormatConstants;
import com.mulesoft.flatfile.lexical.WriterBase;
import com.mulesoft.flatfile.lexical.formats.ExplicitDecimalFormat;
import com.mulesoft.flatfile.lexical.formats.NumberFormatBase;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.MathContext;

@Deprecated
public class OldExplicitDecimalFormat
extends NumberFormatBase {
    private final boolean countDecimal;
    private final boolean zeroBeforeDecimal;
    private final boolean allowExponent;
    private final boolean countExponent;

    public OldExplicitDecimalFormat(String code, int min2, int max, TypeFormatConstants.NumberSign sign, boolean countsign, TypeFormatConstants.FillMode mode, boolean countdec, boolean zerobefore, boolean allowexp, boolean countexp) {
        super(code, min2, max, sign, countsign, mode, '0');
        this.countDecimal = countdec;
        this.zeroBeforeDecimal = zerobefore;
        this.allowExponent = allowexp;
        this.countExponent = countexp;
    }

    public OldExplicitDecimalFormat(ExplicitDecimalFormat format) {
        this(format.typeCode(), format.minLength(), format.maxLength(), format.getNumberSign(), format.getCountSign(), format.getFillMode(), format.getCountDecimal(), format.getZeroBeforeDecimal(), format.getAllowExponent(), format.getCountExponent());
    }

    @Override
    public TypeFormatConstants.GenericType genericType() {
        return TypeFormatConstants.GenericType.REAL;
    }

    protected Object convertDecimalValue(LexerBase lexer) throws LexicalException {
        StringBuilder builder = lexer.tokenBuilder();
        int spaces = this.stripPadding(lexer, this.fillMode, this.fillChar);
        int digits = 0;
        boolean number = false;
        boolean decimal = false;
        int exponent = -1;
        int altmark = lexer.getAltDecimalMark();
        for (int index = (signed = this.signToNormalForm(lexer)) ? 1 : 0; index < builder.length(); ++index) {
            char chr = builder.charAt(index);
            if (chr >= '0' && chr <= '9') {
                number = true;
                if (digits <= 0 && chr == '0') continue;
                ++digits;
                continue;
            }
            if (!(decimal || chr != '.' && chr != altmark)) {
                decimal = true;
                if (chr != altmark) continue;
                builder.setCharAt(index, '.');
                continue;
            }
            if (this.allowExponent && exponent < 0 && (chr == 'E' || chr == 'e')) {
                exponent = index + 1;
                if (digits != 0) continue;
                lexer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "value required before exponent");
                builder.setLength(0);
                builder.append('0');
                continue;
            }
            if ((index == 0 || index == exponent) && chr == '-') continue;
            lexer.error(this, ErrorHandler.ErrorCondition.INVALID_CHARACTER, "character '" + chr + "' not allowed or wrong placement");
            this.invalidCharacter(chr, lexer);
            builder.deleteCharAt(index--);
        }
        if (!number) {
            this.noValuePresent(lexer);
            lexer.tokenBuilder().append('0');
        } else {
            boolean signed;
            int adj = spaces + (!this.countDecimal && decimal ? 1 : 0) + (!this.countSign && signed ? 1 : 0);
            if (exponent > 0) {
                if (!this.countExponent) {
                    ++adj;
                }
                if (!this.countDecimal && builder.length() >= exponent && builder.charAt(exponent) == '-') {
                    ++adj;
                }
            }
            int effective = builder.length() - adj;
            this.validateLength(effective, lexer);
        }
        if (decimal || exponent >= 0) {
            return new BigDecimal(lexer.token());
        }
        return this.convertSizedInteger(lexer, digits);
    }

    private void writeDecimalText(String text, boolean negate, WriterBase writer) throws IOException {
        if (!this.zeroBeforeDecimal && text.startsWith("0")) {
            text = text.substring(1);
        }
        int length = text.length();
        if (!this.countDecimal) {
            --length;
        }
        this.writePadded(text, length, negate, writer);
    }

    @Override
    protected void writeDecimalValue(Object value, WriterBase writer) throws IOException {
        writer.startToken();
        if (value instanceof BigDecimal || value instanceof Double) {
            BigDecimal big = this.convertDoubleAndCastToBigDecimal(value);
            int precision = big.precision();
            int scale = big.scale();
            if (scale <= 0 && precision - scale <= this.maxLength) {
                this.writeBigInteger(big.toBigIntegerExact(), writer);
            } else {
                boolean negate;
                boolean bl = negate = big.signum() < 0;
                if (negate) {
                    big = big.abs();
                }
                if (scale >= 0 && Math.max(precision, scale) <= this.maxLength) {
                    this.writeDecimalText(big.toPlainString(), negate, writer);
                } else if (this.allowExponent) {
                    BigDecimal adjusted = big.movePointRight(scale);
                    String text = adjusted.toBigIntegerExact().toString() + "E" + Integer.toString(-scale);
                    if (!this.zeroBeforeDecimal && text.startsWith("0")) {
                        text = text.substring(1);
                    }
                    int length = text.length() - (this.countExponent ? 0 : 1) - (scale > 0 && !this.countSign ? 1 : 0);
                    this.writePadded(text, length, negate, writer);
                } else {
                    int allowed = this.maxLength - (this.countDecimal ? 1 : 0) - (negate && this.countSign ? 1 : 0);
                    if (allowed + scale < 0) {
                        writer.error(this, ErrorHandler.ErrorCondition.INVALID_FORMAT, "value representation not possible for " + ((BigDecimal)value).toString());
                        this.writePadded("0", 1, false, writer);
                    } else {
                        MathContext mc = new MathContext(allowed);
                        big.round(mc);
                        this.writeDecimalText(big.toPlainString(), negate, writer);
                    }
                }
            }
        } else {
            this.writeIntegerValue(value, writer);
        }
    }

    @Override
    public Object parse(LexerBase lexer) throws LexicalException {
        return this.convertDecimalValue(lexer);
    }

    @Override
    public void write(Object value, WriterBase writer) throws IOException {
        writer.startToken();
        this.writeDecimalValue(value, writer);
    }

    @Override
    public boolean equals(Object obj) {
        if (obj instanceof OldExplicitDecimalFormat && super.equals(obj)) {
            OldExplicitDecimalFormat other = (OldExplicitDecimalFormat)obj;
            return this.allowExponent == other.allowExponent && this.countDecimal == other.countDecimal && this.countExponent == other.countExponent && this.zeroBeforeDecimal == other.zeroBeforeDecimal;
        }
        return false;
    }
}

