/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.atp;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import org.apache.poi.ss.formula.OperationEvaluationContext;
import org.apache.poi.ss.formula.atp.IfError;
import org.apache.poi.ss.formula.atp.IfNa;
import org.apache.poi.ss.formula.atp.Ifs;
import org.apache.poi.ss.formula.atp.MRound;
import org.apache.poi.ss.formula.atp.NetworkdaysFunction;
import org.apache.poi.ss.formula.atp.ParityFunction;
import org.apache.poi.ss.formula.atp.PercentRankExcFunction;
import org.apache.poi.ss.formula.atp.PercentRankIncFunction;
import org.apache.poi.ss.formula.atp.RandBetween;
import org.apache.poi.ss.formula.atp.Stdevp;
import org.apache.poi.ss.formula.atp.Stdevs;
import org.apache.poi.ss.formula.atp.Switch;
import org.apache.poi.ss.formula.atp.TextJoinFunction;
import org.apache.poi.ss.formula.atp.Varp;
import org.apache.poi.ss.formula.atp.Vars;
import org.apache.poi.ss.formula.atp.WorkdayFunction;
import org.apache.poi.ss.formula.atp.WorkdayIntlFunction;
import org.apache.poi.ss.formula.atp.XLookupFunction;
import org.apache.poi.ss.formula.atp.XMatchFunction;
import org.apache.poi.ss.formula.atp.YearFrac;
import org.apache.poi.ss.formula.eval.NotImplementedFunctionException;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.function.FunctionMetadata;
import org.apache.poi.ss.formula.function.FunctionMetadataRegistry;
import org.apache.poi.ss.formula.functions.AverageIf;
import org.apache.poi.ss.formula.functions.Averageifs;
import org.apache.poi.ss.formula.functions.BesselJ;
import org.apache.poi.ss.formula.functions.Bin2Dec;
import org.apache.poi.ss.formula.functions.CeilingMath;
import org.apache.poi.ss.formula.functions.CeilingPrecise;
import org.apache.poi.ss.formula.functions.Complex;
import org.apache.poi.ss.formula.functions.Countifs;
import org.apache.poi.ss.formula.functions.Covar;
import org.apache.poi.ss.formula.functions.Days;
import org.apache.poi.ss.formula.functions.Dec2Bin;
import org.apache.poi.ss.formula.functions.Dec2Hex;
import org.apache.poi.ss.formula.functions.Delta;
import org.apache.poi.ss.formula.functions.DollarDe;
import org.apache.poi.ss.formula.functions.DollarFr;
import org.apache.poi.ss.formula.functions.EDate;
import org.apache.poi.ss.formula.functions.EOMonth;
import org.apache.poi.ss.formula.functions.FactDouble;
import org.apache.poi.ss.formula.functions.FloorMath;
import org.apache.poi.ss.formula.functions.FloorPrecise;
import org.apache.poi.ss.formula.functions.Forecast;
import org.apache.poi.ss.formula.functions.FreeRefFunction;
import org.apache.poi.ss.formula.functions.Gcd;
import org.apache.poi.ss.formula.functions.Hex2Dec;
import org.apache.poi.ss.formula.functions.ImReal;
import org.apache.poi.ss.formula.functions.Imaginary;
import org.apache.poi.ss.formula.functions.Lcm;
import org.apache.poi.ss.formula.functions.Maxifs;
import org.apache.poi.ss.formula.functions.Minifs;
import org.apache.poi.ss.formula.functions.NormDist;
import org.apache.poi.ss.formula.functions.NormInv;
import org.apache.poi.ss.formula.functions.NormSDist;
import org.apache.poi.ss.formula.functions.NormSInv;
import org.apache.poi.ss.formula.functions.NumberValueFunction;
import org.apache.poi.ss.formula.functions.Oct2Dec;
import org.apache.poi.ss.formula.functions.Poisson;
import org.apache.poi.ss.formula.functions.Quotient;
import org.apache.poi.ss.formula.functions.Single;
import org.apache.poi.ss.formula.functions.Sqrtpi;
import org.apache.poi.ss.formula.functions.Sumifs;
import org.apache.poi.ss.formula.functions.TDist2t;
import org.apache.poi.ss.formula.functions.TDistLt;
import org.apache.poi.ss.formula.functions.TDistRt;
import org.apache.poi.ss.formula.functions.TextFunction;
import org.apache.poi.ss.formula.functions.WeekNum;
import org.apache.poi.ss.formula.udf.UDFFinder;

public final class AnalysisToolPak
implements UDFFinder {
    public static final UDFFinder instance = new AnalysisToolPak();
    private final Map<String, FreeRefFunction> _functionsByName = this.createFunctionsMap();

    private AnalysisToolPak() {
    }

    @Override
    public FreeRefFunction findFunction(String name) {
        String prefix = "_xlfn.";
        if (name.startsWith("_xlfn.")) {
            name = name.substring("_xlfn.".length());
        }
        return this._functionsByName.get(name.toUpperCase(Locale.ROOT));
    }

    private Map<String, FreeRefFunction> createFunctionsMap() {
        HashMap<String, FreeRefFunction> m4 = new HashMap<String, FreeRefFunction>(127);
        AnalysisToolPak.r(m4, "ACCRINT", null);
        AnalysisToolPak.r(m4, "ACCRINTM", null);
        AnalysisToolPak.r(m4, "AMORDEGRC", null);
        AnalysisToolPak.r(m4, "AMORLINC", null);
        AnalysisToolPak.r(m4, "AVERAGEIF", AverageIf.instance);
        AnalysisToolPak.r(m4, "AVERAGEIFS", Averageifs.instance);
        AnalysisToolPak.r(m4, "BAHTTEXT", null);
        AnalysisToolPak.r(m4, "BESSELI", null);
        AnalysisToolPak.r(m4, "BESSELJ", BesselJ.instance);
        AnalysisToolPak.r(m4, "BESSELK", null);
        AnalysisToolPak.r(m4, "BESSELY", null);
        AnalysisToolPak.r(m4, "BIN2DEC", Bin2Dec.instance);
        AnalysisToolPak.r(m4, "BIN2HEX", null);
        AnalysisToolPak.r(m4, "BIN2OCT", null);
        AnalysisToolPak.r(m4, "COMPLEX", Complex.instance);
        AnalysisToolPak.r(m4, "CEILING.MATH", CeilingMath.instance);
        AnalysisToolPak.r(m4, "CEILING.PRECISE", CeilingPrecise.instance);
        AnalysisToolPak.r(m4, "CONCAT", TextFunction.CONCAT);
        AnalysisToolPak.r(m4, "CONVERT", null);
        AnalysisToolPak.r(m4, "COUNTIFS", Countifs.instance);
        AnalysisToolPak.r(m4, "COUPDAYBS", null);
        AnalysisToolPak.r(m4, "COUPDAYS", null);
        AnalysisToolPak.r(m4, "COUPDAYSNC", null);
        AnalysisToolPak.r(m4, "COUPNCD", null);
        AnalysisToolPak.r(m4, "COUPNUM", null);
        AnalysisToolPak.r(m4, "COUPPCD", null);
        AnalysisToolPak.r(m4, "COVARIANCE.P", Covar.instanceP);
        AnalysisToolPak.r(m4, "COVARIANCE.S", Covar.instanceS);
        AnalysisToolPak.r(m4, "CUBEKPIMEMBER", null);
        AnalysisToolPak.r(m4, "CUBEMEMBER", null);
        AnalysisToolPak.r(m4, "CUBEMEMBERPROPERTY", null);
        AnalysisToolPak.r(m4, "CUBERANKEDMEMBER", null);
        AnalysisToolPak.r(m4, "CUBESET", null);
        AnalysisToolPak.r(m4, "CUBESETCOUNT", null);
        AnalysisToolPak.r(m4, "CUBEVALUE", null);
        AnalysisToolPak.r(m4, "CUMIPMT", null);
        AnalysisToolPak.r(m4, "CUMPRINC", null);
        AnalysisToolPak.r(m4, "DAYS", Days.instance);
        AnalysisToolPak.r(m4, "DEC2BIN", Dec2Bin.instance);
        AnalysisToolPak.r(m4, "DEC2HEX", Dec2Hex.instance);
        AnalysisToolPak.r(m4, "DEC2OCT", null);
        AnalysisToolPak.r(m4, "DELTA", Delta.instance);
        AnalysisToolPak.r(m4, "DISC", null);
        AnalysisToolPak.r(m4, "DOLLARDE", DollarDe.instance);
        AnalysisToolPak.r(m4, "DOLLARFR", DollarFr.instance);
        AnalysisToolPak.r(m4, "DURATION", null);
        AnalysisToolPak.r(m4, "EDATE", EDate.instance);
        AnalysisToolPak.r(m4, "EFFECT", null);
        AnalysisToolPak.r(m4, "EOMONTH", EOMonth.instance);
        AnalysisToolPak.r(m4, "ERF", null);
        AnalysisToolPak.r(m4, "ERFC", null);
        AnalysisToolPak.r(m4, "FACTDOUBLE", FactDouble.instance);
        AnalysisToolPak.r(m4, "FLOOR.MATH", FloorMath.instance);
        AnalysisToolPak.r(m4, "FLOOR.PRECISE", FloorPrecise.instance);
        AnalysisToolPak.r(m4, "FORECAST.LINEAR", Forecast.instance);
        AnalysisToolPak.r(m4, "FVSCHEDULE", null);
        AnalysisToolPak.r(m4, "GCD", Gcd.instance);
        AnalysisToolPak.r(m4, "GESTEP", null);
        AnalysisToolPak.r(m4, "HEX2BIN", null);
        AnalysisToolPak.r(m4, "HEX2DEC", Hex2Dec.instance);
        AnalysisToolPak.r(m4, "HEX2OCT", null);
        AnalysisToolPak.r(m4, "IFERROR", IfError.instance);
        AnalysisToolPak.r(m4, "IFNA", IfNa.instance);
        AnalysisToolPak.r(m4, "IFS", Ifs.instance);
        AnalysisToolPak.r(m4, "IMABS", null);
        AnalysisToolPak.r(m4, "IMAGINARY", Imaginary.instance);
        AnalysisToolPak.r(m4, "IMARGUMENT", null);
        AnalysisToolPak.r(m4, "IMCONJUGATE", null);
        AnalysisToolPak.r(m4, "IMCOS", null);
        AnalysisToolPak.r(m4, "IMDIV", null);
        AnalysisToolPak.r(m4, "IMEXP", null);
        AnalysisToolPak.r(m4, "IMLN", null);
        AnalysisToolPak.r(m4, "IMLOG10", null);
        AnalysisToolPak.r(m4, "IMLOG2", null);
        AnalysisToolPak.r(m4, "IMPOWER", null);
        AnalysisToolPak.r(m4, "IMPRODUCT", null);
        AnalysisToolPak.r(m4, "IMREAL", ImReal.instance);
        AnalysisToolPak.r(m4, "IMSIN", null);
        AnalysisToolPak.r(m4, "IMSQRT", null);
        AnalysisToolPak.r(m4, "IMSUB", null);
        AnalysisToolPak.r(m4, "IMSUM", null);
        AnalysisToolPak.r(m4, "INTRATE", null);
        AnalysisToolPak.r(m4, "ISEVEN", ParityFunction.IS_EVEN);
        AnalysisToolPak.r(m4, "ISODD", ParityFunction.IS_ODD);
        AnalysisToolPak.r(m4, "JIS", null);
        AnalysisToolPak.r(m4, "LCM", Lcm.instance);
        AnalysisToolPak.r(m4, "MAXIFS", Maxifs.instance);
        AnalysisToolPak.r(m4, "MDURATION", null);
        AnalysisToolPak.r(m4, "MINIFS", Minifs.instance);
        AnalysisToolPak.r(m4, "MROUND", MRound.instance);
        AnalysisToolPak.r(m4, "MULTINOMIAL", null);
        AnalysisToolPak.r(m4, "NETWORKDAYS", NetworkdaysFunction.instance);
        AnalysisToolPak.r(m4, "NOMINAL", null);
        AnalysisToolPak.r(m4, "NORM.DIST", NormDist.instance);
        AnalysisToolPak.r(m4, "NORM.S.DIST", NormSDist.instance);
        AnalysisToolPak.r(m4, "NORM.INV", NormInv.instance);
        AnalysisToolPak.r(m4, "NORM.S.INV", NormSInv.instance);
        AnalysisToolPak.r(m4, "NUMBERVALUE", NumberValueFunction.instance);
        AnalysisToolPak.r(m4, "OCT2BIN", null);
        AnalysisToolPak.r(m4, "OCT2DEC", Oct2Dec.instance);
        AnalysisToolPak.r(m4, "OCT2HEX", null);
        AnalysisToolPak.r(m4, "ODDFPRICE", null);
        AnalysisToolPak.r(m4, "ODDFYIELD", null);
        AnalysisToolPak.r(m4, "ODDLPRICE", null);
        AnalysisToolPak.r(m4, "ODDLYIELD", null);
        AnalysisToolPak.r(m4, "PERCENTRANK.EXC", PercentRankExcFunction.instance);
        AnalysisToolPak.r(m4, "PERCENTRANK.INC", PercentRankIncFunction.instance);
        AnalysisToolPak.r(m4, "POISSON.DIST", Poisson.instance);
        AnalysisToolPak.r(m4, "PRICE", null);
        AnalysisToolPak.r(m4, "PRICEDISC", null);
        AnalysisToolPak.r(m4, "PRICEMAT", null);
        AnalysisToolPak.r(m4, "QUOTIENT", Quotient.instance);
        AnalysisToolPak.r(m4, "RANDBETWEEN", RandBetween.instance);
        AnalysisToolPak.r(m4, "RECEIVED", null);
        AnalysisToolPak.r(m4, "RTD", null);
        AnalysisToolPak.r(m4, "SERIESSUM", null);
        AnalysisToolPak.r(m4, "SINGLE", Single.instance);
        AnalysisToolPak.r(m4, "SQRTPI", Sqrtpi.instance);
        AnalysisToolPak.r(m4, "STDEV.S", Stdevs.instance);
        AnalysisToolPak.r(m4, "STDEV.P", Stdevp.instance);
        AnalysisToolPak.r(m4, "SUMIFS", Sumifs.instance);
        AnalysisToolPak.r(m4, "SWITCH", Switch.instance);
        AnalysisToolPak.r(m4, "TBILLEQ", null);
        AnalysisToolPak.r(m4, "TBILLPRICE", null);
        AnalysisToolPak.r(m4, "TBILLYIELD", null);
        AnalysisToolPak.r(m4, "T.DIST", TDistLt.instance);
        AnalysisToolPak.r(m4, "T.DIST.2T", TDist2t.instance);
        AnalysisToolPak.r(m4, "T.DIST.RT", TDistRt.instance);
        AnalysisToolPak.r(m4, "TEXTJOIN", TextJoinFunction.instance);
        AnalysisToolPak.r(m4, "WEEKNUM", WeekNum.instance);
        AnalysisToolPak.r(m4, "WORKDAY", WorkdayFunction.instance);
        AnalysisToolPak.r(m4, "WORKDAY.INTL", WorkdayIntlFunction.instance);
        AnalysisToolPak.r(m4, "XIRR", null);
        AnalysisToolPak.r(m4, "XLOOKUP", XLookupFunction.instance);
        AnalysisToolPak.r(m4, "XMATCH", XMatchFunction.instance);
        AnalysisToolPak.r(m4, "XNPV", null);
        AnalysisToolPak.r(m4, "YEARFRAC", YearFrac.instance);
        AnalysisToolPak.r(m4, "YIELD", null);
        AnalysisToolPak.r(m4, "YIELDDISC", null);
        AnalysisToolPak.r(m4, "YIELDMAT", null);
        AnalysisToolPak.r(m4, "VAR.S", Vars.instance);
        AnalysisToolPak.r(m4, "VAR.P", Varp.instance);
        return m4;
    }

    private static void r(Map<String, FreeRefFunction> m4, String functionName, FreeRefFunction pFunc) {
        FreeRefFunction func = pFunc == null ? new NotImplemented(functionName) : pFunc;
        m4.put(functionName, func);
    }

    public static boolean isATPFunction(String name) {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        return inst._functionsByName.containsKey(name);
    }

    public static Collection<String> getSupportedFunctionNames() {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        TreeSet<String> lst = new TreeSet<String>();
        for (Map.Entry<String, FreeRefFunction> me : inst._functionsByName.entrySet()) {
            FreeRefFunction func = me.getValue();
            if (func == null || func instanceof NotImplemented) continue;
            lst.add(me.getKey());
        }
        return Collections.unmodifiableCollection(lst);
    }

    public static Collection<String> getNotSupportedFunctionNames() {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        TreeSet<String> lst = new TreeSet<String>();
        for (Map.Entry<String, FreeRefFunction> me : inst._functionsByName.entrySet()) {
            FreeRefFunction func = me.getValue();
            if (!(func instanceof NotImplemented)) continue;
            lst.add(me.getKey());
        }
        return Collections.unmodifiableCollection(lst);
    }

    public static void registerFunction(String name, FreeRefFunction func) {
        AnalysisToolPak inst = (AnalysisToolPak)instance;
        if (!AnalysisToolPak.isATPFunction(name)) {
            FunctionMetadata metaData = FunctionMetadataRegistry.getFunctionByName(name);
            if (metaData != null) {
                throw new IllegalArgumentException(name + " is a built-in Excel function. Use FunctionEval.registerFunction(String name, Function func) instead.");
            }
            throw new IllegalArgumentException(name + " is not a function from the Excel Analysis Toolpack.");
        }
        FreeRefFunction f = inst.findFunction(name);
        if (f != null && !(f instanceof NotImplemented)) {
            throw new IllegalArgumentException("POI already implements " + name + ". You cannot override POI's implementations of Excel functions");
        }
        inst._functionsByName.put(name, func);
    }

    private static final class NotImplemented
    implements FreeRefFunction {
        private final String _functionName;

        public NotImplemented(String functionName) {
            this._functionName = functionName;
        }

        @Override
        public ValueEval evaluate(ValueEval[] args, OperationEvaluationContext ec) {
            throw new NotImplementedFunctionException(this._functionName);
        }
    }
}

