/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.raml.internal.fragments.handler;

import java.util.List;
import java.util.Optional;
import org.mule.metadata.api.builder.BaseTypeBuilder;
import org.mule.metadata.api.builder.NumberTypeBuilder;
import org.mule.metadata.api.builder.TypeBuilder;
import org.mule.metadata.raml.internal.fragments.handler.ParsingContext;
import org.mule.metadata.raml.internal.fragments.handler.TypeDeclarationHandler;
import org.mule.metadata.raml.internal.fragments.handler.TypeDeclarationHandlerManager;
import org.raml.v2.api.model.v10.datamodel.NumberTypeDeclaration;
import org.raml.v2.api.model.v10.datamodel.TypeDeclaration;

public class NumberTypeDeclarationHandler
implements TypeDeclarationHandler {
    @Override
    public boolean handles(TypeDeclaration typeDeclaration) {
        return typeDeclaration instanceof NumberTypeDeclaration;
    }

    @Override
    public TypeBuilder<?> handle(TypeDeclaration typeDeclaration, BaseTypeBuilder root, TypeDeclarationHandlerManager typeDeclarationHandlerManager, ParsingContext parsingContext) {
        List<Number> enumValues;
        NumberTypeDeclaration numberTypeDeclaration = (NumberTypeDeclaration)typeDeclaration;
        NumberTypeBuilder numberTypeBuilder = root.numberType();
        Optional<Double> maximum = Optional.ofNullable(numberTypeDeclaration.maximum());
        Optional<Double> minimum = Optional.ofNullable(numberTypeDeclaration.minimum());
        if (maximum.isPresent() && minimum.isPresent()) {
            numberTypeBuilder.range(minimum.get(), maximum.get());
        }
        if ((enumValues = numberTypeDeclaration.enumValues()) != null && enumValues.size() > 0) {
            numberTypeBuilder.enumOf(enumValues.toArray(new Number[enumValues.size()]));
        }
        return numberTypeBuilder;
    }
}

