/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.api.utils;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Optional;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.SchemaGlobalElement;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.SchemaTypeSystem;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.impl.schema.BuiltinSchemaTypeSystem;
import org.apache.xmlbeans.impl.schema.SchemaTypeLoaderImpl;
import org.apache.xmlbeans.impl.schema.SchemaTypeSystemCompiler;
import org.mule.metadata.internal.utils.StringUtils;
import org.mule.metadata.xml.api.XmlTypeLoader;
import org.w3c.dom.Node;

public class XmlSchemaUtils {
    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<QName> getXmlSchemaRootElementName(List<String> schemas, String example) {
        try {
            SchemaTypeSystem schemaTypeSystem = XmlSchemaUtils.getSchemaTypeSystem(schemas);
            SchemaGlobalElement[] globalElements = schemaTypeSystem.globalElements();
            if (globalElements.length == 1) {
                return Optional.ofNullable(globalElements[0].getName());
            }
            if (globalElements.length > 0 && StringUtils.isNotEmpty(example)) {
                try (StringReader exampleReader = new StringReader(example);){
                    Optional<QName> optional = Optional.ofNullable(XmlSchemaUtils.getRootElementName(exampleReader));
                    return optional;
                }
            }
            if (globalElements.length <= 0) return Optional.empty();
            return Optional.ofNullable(globalElements[0].getName());
        }
        catch (Exception e) {
            throw new RuntimeException("Fail to get XML root element name", e);
        }
    }

    public static QName getRootElementName(Reader xmlDocument) throws IOException {
        XmlObject xmlInstance;
        try {
            xmlInstance = XmlObject.Factory.parse((Reader)xmlDocument);
        }
        catch (XmlException e) {
            throw new IOException(e);
        }
        Node rootNode = xmlInstance.getDomNode().getFirstChild();
        return new QName(rootNode.getNamespaceURI(), rootNode.getLocalName());
    }

    private static SchemaTypeSystem getSchemaTypeSystem(List<String> schemas) throws Exception {
        XmlOptions options = new XmlOptions();
        options.setCompileNoUpaRule();
        options.setCompileNoValidation();
        options.setCompileDownloadUrls();
        XmlObject[] schemaRepresentation = new XmlObject[schemas.size()];
        SchemaTypeLoader contextTypeLoader = SchemaTypeLoaderImpl.build(new SchemaTypeLoader[]{BuiltinSchemaTypeSystem.get()}, null, XmlTypeLoader.class.getClassLoader());
        int i = 0;
        for (String schemaStream : schemas) {
            XmlObject schemaObject;
            schemaRepresentation[i] = schemaObject = contextTypeLoader.parse(schemaStream, null, null);
            ++i;
        }
        return SchemaTypeSystemCompiler.compile(null, null, schemaRepresentation, null, contextTypeLoader, null, options);
    }
}

