/*
 * Decompiled with CFR 0.152.
 */
package org.mule.metadata.xml.internal;

import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.mule.apache.xerces.dom.DOMInputImpl;
import org.mule.apache.xerces.impl.XMLEntityManager;
import org.w3c.dom.ls.LSInput;
import org.w3c.dom.ls.LSResourceResolver;

public class ResourceResolver
implements LSResourceResolver {
    public static final String NO_NAMESPACE = "NO_NAMESPACE";
    private Map<String, List<DOMInputImpl>> schemaByTargetNamespace;

    public ResourceResolver(Map<String, List<DOMInputImpl>> schemaByTargetNamespace) {
        this.schemaByTargetNamespace = schemaByTargetNamespace;
    }

    @Override
    public LSInput resolveResource(String type, String namespaceURI, String publicId, String systemId, String baseURI) {
        String resolvedURI = this.getAbsoluteUri(systemId, baseURI);
        if (org.mule.metadata.internal.utils.StringUtils.isNotEmpty(namespaceURI) && this.schemaByTargetNamespace.containsKey(namespaceURI)) {
            return this.resolveResourceForNamespace(this.schemaByTargetNamespace.get(namespaceURI), resolvedURI);
        }
        if (StringUtils.isEmpty(namespaceURI) && org.mule.metadata.internal.utils.StringUtils.isNotEmpty(systemId)) {
            return this.resolveResourceForNamespace(this.schemaByTargetNamespace.get(NO_NAMESPACE), resolvedURI);
        }
        return null;
    }

    private String getAbsoluteUri(String systemId, String baseURI) {
        try {
            return baseURI == null ? systemId : XMLEntityManager.expandSystemId(systemId, baseURI, false);
        }
        catch (Exception e) {
            return null;
        }
    }

    private LSInput resolveResourceForNamespace(List<DOMInputImpl> domInputs, String systemId) {
        if (domInputs != null) {
            for (DOMInputImpl domInput : domInputs) {
                if (systemId != null && !systemId.equals(domInput.getSystemId())) continue;
                return domInput;
            }
        }
        return null;
    }
}

