/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.api.util;

import java.io.Serializable;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import org.mule.runtime.api.el.DataTypeAware;
import org.mule.runtime.api.metadata.DataType;

public class MultiMap<K, V>
implements Map<K, V>,
Serializable {
    private static final long serialVersionUID = -4723226524524565104L;
    private static final MultiMap EMPTY_MAP = new MultiMap().toImmutableMultiMap();
    protected Map<K, LinkedList<V>> paramsMap;

    public static <K, V> MultiMap<K, V> emptyMultiMap() {
        return EMPTY_MAP;
    }

    public static <K, V> MultiMap<K, V> unmodifiableMultiMap(MultiMap<K, V> m4) {
        Objects.requireNonNull(m4);
        if (m4 instanceof UnmodifiableMultiMap || m4 instanceof ImmutableMultiMap) {
            return m4;
        }
        return new UnmodifiableMultiMap<K, V>(m4);
    }

    public static <T, K, U> Collector<T, ?, MultiMap<K, U>> toMultiMap(Function<? super T, ? extends K> keyMapper, Function<? super T, ? extends U> valueMapper) {
        return Collectors.toMap(keyMapper, valueMapper, (u, v) -> v, () -> new MultiMap());
    }

    public MultiMap(MultiMap<K, V> multiMap) {
        this.paramsMap = new LinkedHashMap<K, LinkedList<LinkedList<V>>>(multiMap.paramsMap);
    }

    public MultiMap(Map<K, V> parametersMap) {
        this.paramsMap = parametersMap.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, e -> {
            LinkedList values = new LinkedList();
            if (e.getValue() instanceof Collection) {
                values.addAll((Collection)e.getValue());
            } else {
                values.add(e.getValue());
            }
            return values;
        }, (u, v) -> {
            throw new IllegalStateException(String.format("Duplicate key %s", u));
        }, LinkedHashMap::new));
        this.paramsMap = Collections.unmodifiableMap(this.paramsMap);
    }

    public MultiMap() {
        this.paramsMap = new LinkedHashMap<K, LinkedList<V>>();
    }

    public MultiMap<K, V> toImmutableMultiMap() {
        if (this instanceof ImmutableMultiMap) {
            return this;
        }
        if (this.isEmpty() && MultiMap.emptyMultiMap() != null) {
            return MultiMap.emptyMultiMap();
        }
        return new ImmutableMultiMap<K, LinkedList<V>>(this.paramsMap);
    }

    @Override
    public int size() {
        return this.paramsMap.values().stream().reduce(0, (count, list) -> list.size() + count, (count, list) -> count);
    }

    @Override
    public boolean isEmpty() {
        return this.paramsMap.isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.paramsMap.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.paramsMap.values().stream().anyMatch(list -> list.contains(value));
    }

    @Override
    public V get(Object key) {
        LinkedList<V> values = this.paramsMap.get(key);
        if (values != null) {
            return values.getFirst();
        }
        return null;
    }

    public List<V> getAll(Object key) {
        LinkedList<V> value = this.paramsMap.get(key);
        if (value != null) {
            return Collections.unmodifiableList(value);
        }
        return Collections.emptyList();
    }

    @Override
    public V put(K key, V value) {
        LinkedList<Object> previousValue = this.paramsMap.get(key);
        V previousItem = this.resolvePreviousItem(previousValue);
        if (previousValue == null) {
            previousValue = new LinkedList();
            this.paramsMap.put(key, previousValue);
        }
        previousValue.add(value);
        return previousItem;
    }

    private V resolvePreviousItem(LinkedList<V> previousValue) {
        if (previousValue == null || previousValue.isEmpty()) {
            return null;
        }
        return previousValue.getFirst();
    }

    @Override
    public void put(K key, Collection<V> values) {
        this.paramsMap.compute(key, (k, curVal) -> {
            if (curVal == null) {
                return new LinkedList(values);
            }
            curVal.addAll(values);
            return curVal;
        });
    }

    @Override
    public V remove(Object key) {
        Collection values = this.paramsMap.remove(key);
        if (values != null) {
            return (V)values.iterator().next();
        }
        return null;
    }

    public List<V> removeAll(Object key) {
        return this.paramsMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> aMap) {
        aMap.forEach((key, value) -> {
            LinkedList<Object> values = new LinkedList<Object>();
            values.add(value);
            this.paramsMap.put(key, values);
        });
    }

    @Override
    public void putAll(MultiMap<? extends K, ? extends V> aMultiMap) {
        aMultiMap.paramsMap.forEach((k, v) -> this.put((K)k, (Collection<V>)v));
    }

    @Override
    public void clear() {
        this.paramsMap.clear();
    }

    @Override
    public Set<K> keySet() {
        return this.paramsMap.keySet();
    }

    @Override
    public Collection<V> values() {
        ArrayList values = new ArrayList();
        this.paramsMap.forEach((key, value) -> values.add(value.getFirst()));
        return values;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        HashSet entries = new HashSet();
        this.paramsMap.forEach((key, value) -> entries.add(new AbstractMap.SimpleEntry(key, value.getFirst())));
        return entries;
    }

    public List<Map.Entry<K, V>> entryList() {
        ArrayList entries = new ArrayList(Math.max(10, this.paramsMap.size() * 2));
        this.paramsMap.forEach((key, values) -> values.forEach((? super T value) -> entries.add(new AbstractMap.SimpleEntry<Object, Object>(key, value))));
        return entries;
    }

    @Override
    public boolean equals(Object o) {
        return o instanceof MultiMap && this.paramsMap.equals(((MultiMap)o).paramsMap);
    }

    @Override
    public int hashCode() {
        return this.paramsMap.hashCode();
    }

    public Map<K, ? extends List<V>> toListValuesMap() {
        return Collections.unmodifiableMap(this.paramsMap);
    }

    public String toString() {
        return "MultiMap{" + Arrays.toString(this.paramsMap.entrySet().toArray()) + '}';
    }

    private static class UnmodifiableMultiMap<K, V>
    extends MultiMap<K, V> {
        private static final long serialVersionUID = 6798199484376351419L;
        private final MultiMap<K, V> m;

        public UnmodifiableMultiMap(MultiMap<K, V> m4) {
            this.m = m4;
        }

        @Override
        public MultiMap<K, V> toImmutableMultiMap() {
            return this.m.toImmutableMultiMap();
        }

        @Override
        public int size() {
            return this.m.size();
        }

        @Override
        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        @Override
        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        @Override
        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        @Override
        public V get(Object key) {
            return this.m.get(key);
        }

        @Override
        public List<V> getAll(Object key) {
            return this.m.getAll(key);
        }

        @Override
        public V put(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void put(K key, Collection<V> values) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V remove(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public List<V> removeAll(Object key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(Map<? extends K, ? extends V> aMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void putAll(MultiMap<? extends K, ? extends V> aMultiMap) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        @Override
        public Set<K> keySet() {
            return Collections.unmodifiableSet(this.m.keySet());
        }

        @Override
        public Collection<V> values() {
            return Collections.unmodifiableCollection(this.m.values());
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return Collections.unmodifiableSet(this.m.entrySet());
        }

        @Override
        public List<Map.Entry<K, V>> entryList() {
            return Collections.unmodifiableList(this.m.entryList());
        }

        @Override
        public boolean equals(Object o) {
            return this.m.equals(o);
        }

        @Override
        public int hashCode() {
            return this.m.hashCode();
        }

        @Override
        public Map<K, ? extends List<V>> toListValuesMap() {
            return this.m.toListValuesMap();
        }

        @Override
        public String toString() {
            return this.m.toString();
        }

        @Override
        public V getOrDefault(Object key, V defaultValue) {
            return this.m.getOrDefault(key, defaultValue);
        }

        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            this.m.forEach(action);
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }
    }

    private static class ImmutableMultiMap<K, V>
    extends MultiMap<K, V> {
        private static final long serialVersionUID = -4581793201929981747L;

        ImmutableMultiMap(Map<K, V> parametersMap) {
            super(parametersMap);
        }

        @Override
        public MultiMap<K, V> toImmutableMultiMap() {
            return this;
        }
    }

    private static class ImmutableStringMultiMap
    extends StringMultiMap
    implements DataTypeAware {
        private static final long serialVersionUID = -4581793201929981747L;

        ImmutableStringMultiMap(Map parametersMap) {
            super(parametersMap);
        }

        @Override
        public DataType getDataType() {
            return DataType.MULTI_MAP_STRING_STRING;
        }

        @Override
        public StringMultiMap toImmutableMultiMap() {
            return this;
        }
    }

    public static class StringMultiMap
    extends MultiMap<String, String>
    implements DataTypeAware {
        private static final StringMultiMap EMPTY_STRING_MAP = new StringMultiMap().toImmutableMultiMap();
        private static final long serialVersionUID = 3153407829619876577L;

        public StringMultiMap() {
        }

        public StringMultiMap(MultiMap<String, String> parametersMap) {
            super(parametersMap);
        }

        public StringMultiMap(Map<String, String> parametersMap) {
            super(parametersMap);
        }

        @Override
        public DataType getDataType() {
            return DataType.MULTI_MAP_STRING_STRING;
        }

        public StringMultiMap toImmutableMultiMap() {
            if (this.isEmpty() && EMPTY_STRING_MAP != null) {
                return EMPTY_STRING_MAP;
            }
            return new ImmutableStringMultiMap(this.paramsMap);
        }
    }
}

