/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api;

import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableSet;
import java.util.Collections;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.mule.runtime.api.meta.model.ExtensionModel;
import org.mule.runtime.ast.api.ArtifactAst;

public enum DependencyResolutionMode {
    MINIMAL{

        @Override
        public Set<ExtensionModel> resolveDependencies(Supplier<Set<ExtensionModel>> extensionModelsSupplier, ArtifactAst artifactAst) {
            Set namespaceUris = artifactAst.recursiveStream().map(c -> c.getIdentifier().getNamespaceUri()).collect(Collectors.toSet());
            return Collections.unmodifiableSet(extensionModelsSupplier.get().stream().filter(em -> namespaceUris.contains(em.getXmlDslModel().getNamespace())).collect(Collectors.toSet()));
        }
    }
    ,
    COMPILED{

        @Override
        public Set<ExtensionModel> resolveDependencies(Supplier<Set<ExtensionModel>> extensionModelsSupplier, ArtifactAst artifactAst) {
            return extensionModelsSupplier.get();
        }
    }
    ,
    WITH_PARENT{

        @Override
        public Set<ExtensionModel> resolveDependencies(Supplier<Set<ExtensionModel>> extensionModelsSupplier, ArtifactAst artifactAst) {
            ImmutableCollection.Builder extensions = new ImmutableSet.Builder().addAll(extensionModelsSupplier.get());
            artifactAst.getParent().map(ArtifactAst::dependencies).ifPresent(((ImmutableSet.Builder)extensions)::addAll);
            return ((ImmutableSet.Builder)extensions).build();
        }
    };


    public static DependencyResolutionMode getDependencyResolutionMode() {
        String sysProp = System.getProperty("mule." + DependencyResolutionMode.class.getName());
        if (sysProp == null) {
            return COMPILED;
        }
        return DependencyResolutionMode.valueOf(sysProp);
    }

    public abstract Set<ExtensionModel> resolveDependencies(Supplier<Set<ExtensionModel>> var1, ArtifactAst var2);
}

