/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.api.util;

import java.util.Collection;
import java.util.Spliterator;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.AstTraversalDirection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BaseComponentAst
implements ComponentAst {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseComponentAst.class);

    @Override
    public Stream<ComponentAst> recursiveStream() {
        return this.recursiveStream(AstTraversalDirection.TOP_DOWN);
    }

    @Override
    public Spliterator<ComponentAst> recursiveSpliterator() {
        return this.recursiveSpliterator(AstTraversalDirection.TOP_DOWN);
    }

    @Override
    public Stream<ComponentAst> recursiveStream(AstTraversalDirection direction) {
        return StreamSupport.stream(this.recursiveSpliterator(direction), false);
    }

    @Override
    public Spliterator<ComponentAst> recursiveSpliterator(AstTraversalDirection direction) {
        return direction.recursiveSpliterator(this);
    }

    @Override
    public Stream<ComponentAst> directChildrenStream() {
        return this.directChildren().stream();
    }

    @Override
    public Spliterator<ComponentAst> directChildrenSpliterator() {
        return this.directChildren().spliterator();
    }

    @Override
    public ComponentParameterAst getParameter(String groupName, String paramName) {
        return this.doGetParameter(this.getParameters(), groupName, paramName);
    }

    protected ComponentParameterAst doGetParameter(Collection<ComponentParameterAst> parameters, String groupName, String paramName) {
        ComponentParameterAst found = parameters.stream().filter(param2 -> this.matchesGroupAndName((ComponentParameterAst)param2, groupName, paramName)).findFirst().orElse(null);
        if (found == null && LOGGER.isDebugEnabled()) {
            parameters.stream().filter(param2 -> this.matchesName((ComponentParameterAst)param2, paramName)).findFirst().ifPresent(param2 -> LOGGER.debug("Requested parameter ({}, {}) not found, but a there is a parameter with the same name: ({}, {})", groupName, paramName, this.getGroupName((ComponentParameterAst)param2), paramName));
        }
        return found;
    }

    private boolean matchesName(ComponentParameterAst componentParameterAst, String paramName) {
        return componentParameterAst.getModel().getName().equals(paramName);
    }

    private boolean matchesGroupAndName(ComponentParameterAst componentParameterAst, String groupName, String paramName) {
        if (!this.matchesName(componentParameterAst, paramName)) {
            return false;
        }
        String actualGroupName = this.getGroupName(componentParameterAst);
        if (actualGroupName == null) {
            return true;
        }
        return actualGroupName.equals(groupName);
    }

    private String getGroupName(ComponentParameterAst componentParameterAst) {
        ParameterGroupModel groupModel = componentParameterAst.getGroupModel();
        if (groupModel == null) {
            return null;
        }
        return groupModel.getName();
    }

    public String toString() {
        return this.getComponentId().map(n -> "" + n + "(" + this.getIdentifier().toString() + ")").orElse(this.getIdentifier().toString()) + (this.getLocation() != null ? " @ " + this.getLocation().getLocation() : "");
    }
}

