/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.graph.api;

import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.jgrapht.Graph;
import org.jgrapht.graph.SimpleDirectedGraph;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.api.util.Pair;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.MuleAstUtils;
import org.mule.runtime.ast.graph.api.ArtifactAstDependencyGraph;
import org.mule.runtime.ast.graph.api.ComponentAstDependency;
import org.mule.runtime.ast.graph.internal.ComponentAstEdge;
import org.mule.runtime.ast.graph.internal.DefaultArtifactAstDependencyGraph;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ArtifactAstDependencyGraphFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(ArtifactAstDependencyGraphFactory.class);

    private ArtifactAstDependencyGraphFactory() {
    }

    public static ArtifactAstDependencyGraph generateFor(ArtifactAst fullArtifactAst) {
        SimpleDirectedGraph<ComponentAst, ComponentAstEdge> graph = new SimpleDirectedGraph<ComponentAst, ComponentAstEdge>(ComponentAstEdge.class);
        fullArtifactAst.recursiveStream().forEach(graph::addVertex);
        HashSet<ComponentAstDependency> missingDependencies = new HashSet<ComponentAstDependency>();
        fullArtifactAst.recursiveStream().forEach(comp -> {
            comp.directChildrenStream().forEach(child -> ArtifactAstDependencyGraphFactory.addDependency(graph, comp, child));
            comp.getModel(ParameterizedModel.class).ifPresent(parameterizedModel -> comp.getParameters().forEach(param2 -> MuleAstUtils.doOnParamComponents(param2, child -> ArtifactAstDependencyGraphFactory.addDependency(graph, comp, child))));
            comp.getModel(ParameterizedModel.class).ifPresent(parameterizedModel -> parameterizedModel.getParameterGroupModels().stream().flatMap(g2 -> g2.getParameterModels().stream().map(p -> new Pair<ParameterGroupModel, ParameterModel>((ParameterGroupModel)g2, (ParameterModel)p))).filter(groupAndParam -> !((ParameterModel)groupAndParam.getSecond()).getAllowedStereotypes().isEmpty()).filter(groupAndParam -> ArtifactAstDependencyGraphFactory.parameterValue(comp, (ParameterGroupModel)groupAndParam.getFirst(), (ParameterModel)groupAndParam.getSecond()) != null).map(groupAndParam -> new ComponentAstDependency((ComponentAst)comp, comp.getParameter(((ParameterGroupModel)groupAndParam.getFirst()).getName(), ((ParameterModel)groupAndParam.getSecond()).getName()), ArtifactAstDependencyGraphFactory.parameterValue(comp, (ParameterGroupModel)groupAndParam.getFirst(), (ParameterModel)groupAndParam.getSecond()), (Set<StereotypeModel>)new HashSet<StereotypeModel>(((ParameterModel)groupAndParam.getSecond()).getAllowedStereotypes()))).forEach(dependency -> {
                if (missingDependencies.contains(dependency)) {
                    return;
                }
                fullArtifactAst.filteredComponents(tlcm -> !graph.containsEdge((ComponentAst)comp, (ComponentAst)tlcm)).filter(dependency::isSatisfiedBy).forEach(tlcm -> ArtifactAstDependencyGraphFactory.addDependency(graph, comp, tlcm));
                if (graph.outgoingEdgesOf((ComponentAst)comp).stream().noneMatch(edge -> dependency.isSatisfiedBy(edge.getTarget()))) {
                    missingDependencies.add((ComponentAstDependency)dependency);
                }
            }));
        });
        if (!missingDependencies.isEmpty() && LOGGER.isDebugEnabled()) {
            LOGGER.debug("Missing dependencies:");
            missingDependencies.forEach(rq -> LOGGER.debug("    {}", rq));
        }
        return new DefaultArtifactAstDependencyGraph(fullArtifactAst, graph, missingDependencies);
    }

    private static String parameterValue(ComponentAst comp, ParameterGroupModel groupModel, ParameterModel paramModel) {
        ComponentParameterAst param2 = comp.getParameter(groupModel.getName(), paramModel.getName());
        if (param2 != null && param2.getValue().isRight() && param2.getValue().getRight() != null) {
            return param2.getValue().getRight() instanceof String ? Objects.toString(param2.getValue().getRight()) : null;
        }
        return null;
    }

    private static void addDependency(Graph<ComponentAst, ComponentAstEdge> graph, ComponentAst dependencyFrom, ComponentAst dependencyTo) {
        LOGGER.debug("Dependency found: '{}' to '{}'", (Object)dependencyFrom, (Object)dependencyTo);
        graph.addEdge(dependencyFrom, dependencyTo);
    }
}

