/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.ast.internal.builder.adapter;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.mule.metadata.api.model.MetadataType;
import org.mule.metadata.api.model.ObjectFieldType;
import org.mule.metadata.api.model.ObjectType;
import org.mule.runtime.api.meta.ExpressionSupport;
import org.mule.runtime.api.meta.NamedObject;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.display.DisplayModel;
import org.mule.runtime.api.meta.model.display.LayoutModel;
import org.mule.runtime.api.meta.model.parameter.ExclusiveParametersModel;
import org.mule.runtime.api.meta.model.parameter.ParameterGroupModel;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterRole;
import org.mule.runtime.ast.internal.builder.adapter.MetadataTypeExclusiveParametersModelAdapter;
import org.mule.runtime.ast.internal.builder.adapter.ObjectFieldTypeAsParameterModelAdapter;
import org.mule.runtime.extension.api.declaration.type.annotation.ExclusiveOptionalsTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.FlattenedTypeAnnotation;
import org.mule.runtime.extension.api.declaration.type.annotation.QNameTypeAnnotation;
import org.mule.runtime.extension.api.model.parameter.ImmutableParameterModel;
import org.mule.runtime.extension.api.util.NameUtils;

class ObjectTypeAsParameterGroupAdapter
implements ParameterGroupModel {
    private final ObjectType adaptedType;
    private final String groupName;
    private final Map<String, ParameterModel> parameterModelsByName;
    private final List<ParameterModel> parameterModels;
    private final List<ExclusiveParametersModel> exclusiveParametersModel;

    public ObjectTypeAsParameterGroupAdapter(ObjectType adaptedType, MetadataType stringType) {
        this.adaptedType = adaptedType;
        this.groupName = this.resolveGroupName(adaptedType);
        ArrayList<ImmutableParameterModel> tempParameterModels = new ArrayList<ImmutableParameterModel>();
        ArrayList tempExclusiveParametersModels = new ArrayList();
        for (ObjectFieldType wrappedFieldType : adaptedType.getFields()) {
            Stream<ObjectFieldType> fieldTypes = wrappedFieldType.getAnnotation(FlattenedTypeAnnotation.class).isPresent() && wrappedFieldType.getValue() instanceof ObjectType ? ((ObjectType)wrappedFieldType.getValue()).getFields().stream() : Stream.of(wrappedFieldType);
            tempParameterModels.addAll(fieldTypes.map(field2 -> new ObjectFieldTypeAsParameterModelAdapter((ObjectFieldType)field2, adaptedType.getAnnotation(QNameTypeAnnotation.class).map(QNameTypeAnnotation::getValue))).collect(Collectors.toList()));
            wrappedFieldType.getAnnotation(ExclusiveOptionalsTypeAnnotation.class).map(MetadataTypeExclusiveParametersModelAdapter::new).ifPresent(tempExclusiveParametersModels::add);
        }
        Collections.sort(tempParameterModels, Comparator.comparing(NamedObject::getName));
        Collections.sort(tempExclusiveParametersModels, Comparator.comparing(excl -> excl.getExclusiveParameterNames().iterator().next()));
        this.parameterModelsByName = tempParameterModels.stream().collect(Collectors.toMap(NamedObject::getName, Function.identity()));
        if (!this.parameterModelsByName.containsKey("name")) {
            ImmutableParameterModel nameParam = new ImmutableParameterModel("name", "The name of this object in the DSL", stringType, false, true, false, true, ExpressionSupport.NOT_SUPPORTED, null, ParameterRole.BEHAVIOUR, null, null, null, null, Collections.emptyList(), Collections.emptySet());
            this.parameterModelsByName.put("name", nameParam);
            tempParameterModels.add(nameParam);
        }
        this.parameterModels = Collections.unmodifiableList(tempParameterModels);
        this.exclusiveParametersModel = Collections.unmodifiableList(tempExclusiveParametersModels);
    }

    private String resolveGroupName(ObjectType adaptedType) {
        String aliasName;
        try {
            aliasName = NameUtils.getAliasName(adaptedType);
        }
        catch (IllegalArgumentException e) {
            aliasName = "General";
        }
        return aliasName;
    }

    @Override
    public List<ParameterModel> getParameterModels() {
        return this.parameterModels;
    }

    @Override
    public Optional<ParameterModel> getParameter(String name) {
        return Optional.ofNullable(this.parameterModelsByName.get(name));
    }

    @Override
    public String getName() {
        return this.groupName;
    }

    @Override
    public String getDescription() {
        return "";
    }

    @Override
    public Optional<DisplayModel> getDisplayModel() {
        return Optional.empty();
    }

    @Override
    public Optional<LayoutModel> getLayoutModel() {
        return Optional.empty();
    }

    @Override
    public <T extends ModelProperty> Optional<T> getModelProperty(Class<T> propertyType) {
        return Optional.empty();
    }

    @Override
    public Set<ModelProperty> getModelProperties() {
        return Collections.emptySet();
    }

    @Override
    public List<ExclusiveParametersModel> getExclusiveParametersModels() {
        return this.exclusiveParametersModel;
    }

    @Override
    public boolean isShowInDsl() {
        return false;
    }

    public String toString() {
        return "ObjectTypeAsParameterGroupAdapter{" + this.getName() + "; " + this.adaptedType.toString() + "}";
    }
}

