/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.function.Supplier;
import java.util.stream.Stream;
import org.mule.runtime.api.el.ExpressionLanguage;
import org.mule.runtime.api.el.validation.Severity;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.config.internal.validation.ValidationUtils;

public abstract class AbstractExpressionSyntacticallyValid
implements Validation {
    protected final ExpressionLanguage expressionLanguage;
    private final Supplier<Validation.Level> level;
    private final Severity severity;

    public AbstractExpressionSyntacticallyValid(ExpressionLanguage expressionLanguage, Supplier<Validation.Level> level, Severity severity) {
        this.expressionLanguage = expressionLanguage;
        this.level = level;
        this.severity = severity;
    }

    protected final Stream<ValidationResultItem> validateExpression(ComponentAst component, ComponentParameterAst param2, String expression) {
        return this.expressionLanguage.validate(expression).messages().stream().filter(msg -> msg.getSeverity().equals((Object)this.getSeverity())).map(msg -> ValidationResultItem.create(component, param2, (Validation)this, msg.getMessage(), ValidationUtils.locationToAdditionalData(msg.getLocation())));
    }

    @Override
    public final Validation.Level getLevel() {
        return this.level.get();
    }

    protected final Severity getSeverity() {
        return this.severity;
    }
}

