/*
 * Decompiled with CFR 0.152.
 */
package org.mule.runtime.config.internal.validation;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.mule.runtime.api.functional.Either;
import org.mule.runtime.api.meta.model.ModelProperty;
import org.mule.runtime.api.meta.model.parameter.ParameterModel;
import org.mule.runtime.api.meta.model.parameter.ParameterizedModel;
import org.mule.runtime.api.meta.model.stereotype.StereotypeModel;
import org.mule.runtime.ast.api.ArtifactAst;
import org.mule.runtime.ast.api.ComponentAst;
import org.mule.runtime.ast.api.ComponentParameterAst;
import org.mule.runtime.ast.api.util.ComponentAstPredicatesFactory;
import org.mule.runtime.ast.api.validation.Validation;
import org.mule.runtime.ast.api.validation.ValidationResultItem;
import org.mule.runtime.extension.api.util.ExtensionModelUtils;

public class DynamicConfigWithStatefulOperationConfigurationOverride
implements Validation {
    private static final Class<? extends ModelProperty> fieldOperationParameterModelProperty;

    @Override
    public String getName() {
        return "Dynamic config with stateful operation @ConfigOverride";
    }

    @Override
    public String getDescription() {
        return "Dynamic config with stateful operation @ConfigOverride";
    }

    @Override
    public Validation.Level getLevel() {
        return Validation.Level.ERROR;
    }

    @Override
    public Predicate<List<ComponentAst>> applicable() {
        if (fieldOperationParameterModelProperty == null) {
            return v -> false;
        }
        return ComponentAstPredicatesFactory.currentElemement(component -> !this.getConfigOverrideParams((ComponentAst)component).isEmpty());
    }

    @Override
    public Optional<ValidationResultItem> validate(ComponentAst component, ArtifactAst artifact) {
        return this.getConfigOverrideParams(component).stream().filter(param2 -> {
            ComponentParameterAst configRefParam = component.getParameter("General", "config-ref");
            String explicitConfigName = (String)configRefParam.getValue().getRight();
            if (explicitConfigName == null) {
                return this.hasImplicitOverriddenDynamicParameter(component, (ComponentParameterAst)param2, configRefParam);
            }
            return this.hasOverriddenDynamicParameter(artifact, (ComponentParameterAst)param2, explicitConfigName);
        }).filter(parameter -> parameter.getValueOrResolutionError().equals(Either.empty())).findFirst().map(parameter -> ValidationResultItem.create(component, parameter, (Validation)this, "Component uses a dynamic configuration and defines configuration override parameter '" + parameter.getModel().getName() + "' which is assigned on initialization. That combination is not supported. Please use a non dynamic configuration or don't set the parameter."));
    }

    private boolean hasImplicitOverriddenDynamicParameter(ComponentAst component, ComponentParameterAst param2, ComponentParameterAst configRefParam) {
        Optional implicitOverriddenDynamicParameter = component.getExtensionModel().getConfigurationModels().stream().filter(cfgModel -> configRefParam.getModel().getAllowedStereotypes().stream().anyMatch(allwedStereotype -> cfgModel.getStereotype().isAssignableTo((StereotypeModel)allwedStereotype))).findFirst().flatMap(cfgModel -> cfgModel.getParameterGroupModels().stream().filter(cfgPmg -> cfgPmg.getName().equals(param2.getGroupModel().getName())).map(cfgPmg -> cfgPmg.getParameter(param2.getModel().getName())).filter(Optional::isPresent).map(Optional::get).filter(ExtensionModelUtils::hasExpressionDefaultValue).findFirst());
        return implicitOverriddenDynamicParameter.isPresent();
    }

    private boolean hasOverriddenDynamicParameter(ArtifactAst artifact, ComponentParameterAst param2, String explicitConfigName) {
        return artifact.topLevelComponentsStream().filter(topLevel -> topLevel.getComponentId().map(explicitConfigName::equals).orElse(false)).anyMatch(config -> {
            ComponentParameterAst overriddenDynamicParameter = config.getParameter(param2.getGroupModel().getName(), param2.getModel().getName());
            return overriddenDynamicParameter != null && overriddenDynamicParameter.getValueOrResolutionError().isLeft();
        });
    }

    protected List<ComponentParameterAst> getConfigOverrideParams(ComponentAst component) {
        return component.getModel(ParameterizedModel.class).map(pmzd -> pmzd.getParameterGroupModels().stream().flatMap(pmg -> pmg.getParameterModels().stream().filter(ParameterModel::isOverrideFromConfig).filter(pm -> pm.getModelProperty(fieldOperationParameterModelProperty).isPresent()).map(pm -> component.getParameter(pmg.getName(), pm.getName()))).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    static {
        Class<?> foundClass = null;
        try {
            foundClass = Class.forName("org.mule.runtime.module.extension.internal.loader.java.property.FieldOperationParameterModelProperty");
        }
        catch (ClassNotFoundException | SecurityException exception) {
            // empty catch block
        }
        fieldOperationParameterModelProperty = foundClass;
    }
}

